/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.event.job.domain.services.impls;

import com.bcxin.event.core.exceptions.ConflictEventException;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.event.job.domain.commands.CreateJdbcDefinitionCommand;
import com.bcxin.event.job.domain.commands.UpdateJdbcDefinitionCommand;
import com.bcxin.event.job.domain.entities.JdbcDefinitionEntity;
import com.bcxin.event.job.domain.repositories.JdbcDefinitionRepository;
import com.bcxin.event.job.domain.services.JdbcDefinitionService;

public class JdbcDefinitionServiceImpl
implements JdbcDefinitionService {
    private final JdbcDefinitionRepository jdbcDefinitionRepository;

    public JdbcDefinitionServiceImpl(JdbcDefinitionRepository jdbcDefinitionRepository) {
        this.jdbcDefinitionRepository = jdbcDefinitionRepository;
    }

    @Override
    public void dispatch(CreateJdbcDefinitionCommand command) {
        JdbcDefinitionEntity jdbcDefinition = JdbcDefinitionEntity.create(command.getName(), command.getDriveClassName(), command.getUrl(), command.getUserName(), command.getPassword(), command.getConnectionTimeZone());
        try {
            this.jdbcDefinitionRepository.create(jdbcDefinition);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_jdbc_name")) {
                throw new ConflictEventException("\u8be5\u540d\u79f0\u7684Jdbc\u914d\u7f6e\u5df2\u7ecf\u5b58\u5728");
            }
            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    public void dispatch(UpdateJdbcDefinitionCommand command) {
        JdbcDefinitionEntity jdbcDefinition = (JdbcDefinitionEntity)this.jdbcDefinitionRepository.getById(command.getId());
        if (jdbcDefinition == null) {
            throw new NoFoundEventException(String.format("\u627e\u4e0d\u5230\u8be5\u914d\u7f6e(%s)\u4fe1\u606f", command.getId()));
        }
        try {
            jdbcDefinition.change(command.getName(), command.getDriveClassName(), command.getUrl(), command.getUserName(), command.getPassword(), command.getConnectionTimeZone());
            this.jdbcDefinitionRepository.update(jdbcDefinition);
        }
        catch (Exception ex) {
            if (ex.toString().contains("unique_jdbc_name")) {
                throw new ConflictEventException("\u8be5\u540d\u79f0\u7684Jdbc\u914d\u7f6e\u5df2\u7ecf\u5b58\u5728");
            }
            ex.printStackTrace();
            throw ex;
        }
    }
}

