package com.zbkj.front.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.utils.RestTemplateUtil;
import com.zbkj.service.service.SystemConfigService;
import lombok.extern.slf4j.Slf4j;
//import org.junit.Test;
//import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

@Slf4j
//@RunWith(SpringRunner.class)
//@SpringBootTest
public class FrontOrderServiceImplTest {
    @Resource
    RestTemplateUtil restTemplateUtil;
    @Resource
    private SystemConfigService systemConfigService;
//    @Test
    public void testRest(){
        BCryptPasswordEncoder bcryptEncoder=new BCryptPasswordEncoder();
        String pass = bcryptEncoder.encode("ad4_319bca03dd1.54");
        Map<String, String> header = new HashMap<>();
        header.put("access_token",pass);

        JSONObject result = restTemplateUtil.post(systemConfigService.getRiskSystemUrl() + "/wechat/cost/" + 1274,header);
        log.info(result.toJSONString());
        Map<String, Object> body = new HashMap<>();
        body.put("activityNo","OD169674676196252758");
        body.put("costId","1274");
        body.put("amount","20500");
        result = restTemplateUtil.postJson(systemConfigService.getRiskSystemUrl() + "/wechat/wechat-enter-activity-info" , new JSONObject(body),header);
        log.info(result.toJSONString());
        Map<String, Object> body1 = new HashMap<>();
        body1.put("activityNo","OD169674676196252758");
        result = restTemplateUtil.post(systemConfigService.getRiskSystemUrl() + "/wechat/cancel?activityNo=OD169674676196252758",new JSONObject(body1),header);
        log.info(result.toJSONString());


    }

    public static void main(String[] args) {
        BCryptPasswordEncoder bcryptEncoder=new BCryptPasswordEncoder();
        String raw = "ad4_319bca03dd1.54";
        String pass = bcryptEncoder.encode(raw);
        bcryptEncoder.matches(raw,pass);
    }
}