package com.zbkj.front.controller;


import com.zbkj.common.request.UserOrgFxsSearchRequest;
import com.zbkj.common.response.bcx.LoginOrgResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户组织控制器
 */
@Slf4j
@RestController
@RequestMapping("api/front/user/org")
@Api(tags = "用户组织控制器")
public class UserOrgController {

    @Resource
    private UserService userService;


    @ApiOperation(value = "获取用户分销商组织列表")
    @RequestMapping(value = "/fxs/list", method = RequestMethod.POST)
    public CommonResult<List<LoginOrgResponse>> getFxsList(@ModelAttribute UserOrgFxsSearchRequest request) {
        return CommonResult.success(userService.getFxsList(request));
    }

}



