package com.zbkj.front.controller;

import com.zbkj.common.model.bcx.BcxUserBank;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxUserAddBankCardRequest;
import com.zbkj.common.request.BcxUserEditBankCardRequest;
import com.zbkj.common.request.BcxUserOperateBankCardRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxUserBankService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * description：用户绑定银行卡表 控制层
 * author：linchunpeng
 * date：2023/11/1
 */
@Slf4j
@Api(tags = "用户绑定银行卡 控制层")
@RestController
@RequestMapping("/api/front/user/bank")
public class UserBankController {

    @Autowired
    private BcxUserBankService bcxUserBankService;

    @ApiOperation(value = "获取银行卡列表")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxUserBank>> getList(PageParamRequest pageParamRequest) {
        return CommonResult.success(CommonPage.restPage(bcxUserBankService.getPage(pageParamRequest)));
    }

    @ApiOperation(value = "绑定银行卡")
    @RequestMapping(value = "/bind", method = RequestMethod.POST)
    public CommonResult<Object> bind(@RequestBody @Validated BcxUserAddBankCardRequest request) {
        return CommonResult.success(bcxUserBankService.bindBankCard(request));
    }

    @ApiOperation(value = "编辑银行卡")
    @RequestMapping(value = "/edit", method = RequestMethod.POST)
    public CommonResult<Object> edit(@RequestBody @Validated BcxUserEditBankCardRequest request) {
        return CommonResult.success(bcxUserBankService.editBankCard(request));
    }

    @ApiOperation(value = "设置默认银行卡")
    @RequestMapping(value = "/set/default", method = RequestMethod.POST)
    public CommonResult<Object> setDefault(@RequestBody @Validated BcxUserOperateBankCardRequest request) {
        return CommonResult.success(bcxUserBankService.setBankCardDefault(request));
    }

    @ApiOperation(value = "解绑银行卡")
    @RequestMapping(value = "/unbind", method = RequestMethod.POST)
    public CommonResult<Object> unbind(@RequestBody @Validated BcxUserOperateBankCardRequest request) {
        return CommonResult.success(bcxUserBankService.unbindBankCard(request));
    }
}