package com.zbkj.common.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 业绩报表 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxPerformanceReportResponse对象", description = "业绩报表 response对象")
public class BcxPerformanceReportResponse implements Serializable {

    @ApiModelProperty(value = "业绩报表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "订单id")
    private Integer orderId;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "订单区域")
    private String orderRegion;

    @ApiModelProperty(value = "下单用户id")
    private Integer orderUserId;

    @ApiModelProperty(value = "下单用户实际姓名")
    private String orderUserRealName;

    @ApiModelProperty(value = "下单用户手机号")
    private String orderUserPhone;

    @ApiModelProperty(value = "下单时间")
    private Date orderTime;

    @ApiModelProperty(value = "订单明细id")
    private Integer orderDetailId;

    @ApiModelProperty(value = "商品id")
    private Integer productId;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "商品规格值id")
    private Integer attrValueId;

    @ApiModelProperty(value = "商品sku")
    private String sku;

    @ApiModelProperty(value = "实际支付金额")
    private BigDecimal payPrice;

    @ApiModelProperty(value = "实际业务量，计算公式：实际支付金额 * 计算系数")
    private BigDecimal payPriceCalculate;

    @ApiModelProperty(value = "佣金配置类型：1默认比例，2自定义比例")
    private Integer brokerageConfigType;

    @ApiModelProperty(value = "佣金类型：1比例，2固定，3自留")
    private Integer brokerageType;

    @ApiModelProperty(value = "是否服务绩效：1是，0否")
    private Integer isServe;

    @ApiModelProperty(value = "佣金比例")
    private BigDecimal brokerageRatio;

    @ApiModelProperty(value = "计算系数")
    private BigDecimal brokerageCalculateRatio;

    @ApiModelProperty(value = "佣金金额")
    private BigDecimal brokeragePrice;

    @ApiModelProperty(value = "分账状态：1已分账，0未分账")
    private Integer separateAccountStatus;

    @ApiModelProperty(value = "结算状态：1待生效，2冻结中，3待结算，4结算中，5已结算，6无效")
    private Integer settleStatus;

    @ApiModelProperty(value = "解冻时间")
    private Date unFreezeTime;

    @ApiModelProperty(value = "结算时间")
    private Date settleTime;

    @ApiModelProperty(value = "所属账单id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long settleBillId;

    @ApiModelProperty(value = "结算凭证id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long settleBillAttachmentsId;



    @ApiModelProperty(value = "关联id：渠道表id，部门表id，部门成员表id，用户表id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long belongId;

    @ApiModelProperty(value = "渠道商名称")
    private String channelName;

    @ApiModelProperty(value = "部门名称")
    private String departmentName;

    @ApiModelProperty(value = "部门成员姓名")
    private String departmentMemberName;

    @ApiModelProperty(value = "分销员类型：1企业，2个人")
    private Integer brokerageUserType;

    @ApiModelProperty(value = "分销员姓名")
    private String brokerageUserRealName;

    @ApiModelProperty(value = "分销员昵称")
    private String brokerageUserNikeName;

    @ApiModelProperty(value = "分销员手机")
    private String brokerageUserPhone;

    @ApiModelProperty(value = "分销员所属企业")
    private String brokerageUserOrg;

}