package com.zbkj.common.request.bcx;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 批量开票请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BcxWriteFapiaoRequest对象", description = "批量开票请求对象")
public class BcxWriteFapiaoRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "开票申请单号", required = true)
    @ExcelProperty(value = "开票申请单号",index = 0)
    private String applyNo;

    @ApiModelProperty(value = "发票号码", required = true)
    @ExcelProperty(value = "发票号码", index = 1)
    private String fapiaoNo;

    @ApiModelProperty(value = "销方识别号")
    @ExcelProperty(value = "发票号码", index = 2)
    private String vendorId;

    @ApiModelProperty(value = "销方名称")
    @ExcelProperty(value = "发票号码", index = 3)
    private String vendorName;

    @ApiModelProperty(value = "发票来源")
    @ExcelProperty(value = "发票号码", index = 4)
    private String fapiaoOrg;

    @ApiModelProperty(value = "开票时间")
    @ExcelProperty(value = "开票时间", index = 5)
    private String writeTime;

    @ApiModelProperty(value = "拒绝原因")
    @ExcelProperty(value = "拒绝原因", index = 6)
    private String rejectReason;
}
