package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * description：结算单上传附件request对象
 * author：linchunpeng
 * date：2023/8/4
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxSettleUploadAttachmentsRequest对象", description = "结算单上传附件request对象")
public class BcxSettleUploadAttachmentsRequest {

    @ApiModelProperty(value = "结算单id")
    @NotNull(message = "结算单id不能为空")
    private Long settleId;

    @ApiModelProperty(value = "结算发票列表")
    private List<BcxSettleAttachmentsRequest> settleInvoiceList;

    @ApiModelProperty(value = "结算凭证列表")
    private List<BcxSettleAttachmentsRequest> settleProofList;

}
