package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 商城商品菜单请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxProductMenuRequest对象", description = "商城商品菜单请求对象")
public class BcxProductMenuRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "菜单ID，新增时不填，修改时必填")
    private Integer id;

    @ApiModelProperty(value = "父级ID，level=1的时候传0，level !=1 的时候传父级id")
    @NotNull(message = "父级ID不能为空")
    private Integer pid;

    @ApiModelProperty(value = "菜单名称")
    @NotEmpty(message = "菜单名称不能为空")
    @Length(max = 100, message = "菜单名称不能超过50个字符")
    private String name;

    @ApiModelProperty(value = "级别:1，2，3")
    @NotNull(message = "分类级别不能为空")
    @Range(min = 1, max = 3, message = "未知的分类级别")
    private Integer level;

    @ApiModelProperty(value = "商品一级分类id")
    private Integer categoryId;

    @ApiModelProperty(value = "排序")
    @NotNull(message = "排序不能为空")
    @Range(min = 0, max = 9999, message = "排序最范围为0-9999")
    private Integer sort;

    @ApiModelProperty(value = "菜单类型 0- PC菜单")
    @Range(min = 0, max = 0, message = "现只支持pc菜单")
    private Integer type;
}
