/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.handle;

import com.zbkj.service.wangshang.api.MybankApiException;
import com.zbkj.service.wangshang.api.MybankApiExceptionEnum;
import com.zbkj.service.wangshang.api.config.FunctionEnum;
import com.zbkj.service.wangshang.api.config.MybankConfig;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.RespInfo;
import com.zbkj.service.wangshang.api.domain.Response;
import com.zbkj.service.wangshang.api.domain.ResponseBody;
import com.zbkj.service.wangshang.api.domain.ResponseDocument;
import com.zbkj.service.wangshang.api.domain.ResponseHead;
import com.zbkj.service.wangshang.api.internal.mapping.DefaultSigner;
import com.zbkj.service.wangshang.api.internal.util.JaxbUtil;
import com.zbkj.service.wangshang.api.internal.util.MybankSignature;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsNotifyResponseBody;
import com.zbkj.service.wangshang.api.service.notify.BkmerchantSettleNotifyPayResultResponseBody;
import com.zbkj.service.wangshang.handle.StrategyFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class CommomRequstHandle {
    @Autowired
    private StrategyFactory strategyFactory;

    public String getXmlContextString(HttpServletRequest httpServletRequest) throws MybankApiException {
        StringWriter writer = new StringWriter();
        BufferedReader reader = null;
        try {
            reader = httpServletRequest.getReader();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
        }
        catch (Exception e) {
            throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
                }
            }
        }
        return writer.toString();
    }

    public String notifyRequstHandle(String xmlContext) throws MybankApiException {
        String functionName = null;
        String result = null;
        try {
            functionName = this.getNotifyFunction(xmlContext);
            result = this.strategyFactory.getStrategy(FunctionEnum.getStrategyValue(functionName)).notifyHandle(xmlContext, functionName);
        }
        catch (Exception e) {
            throw new MybankApiException(e);
        }
        return result;
    }

    public void checkNotifyRequest(String xmlContext) throws MybankApiException {
        boolean signBool = this.checkSign(xmlContext);
        if (!signBool) {
            throw new MybankApiException(MybankApiExceptionEnum.VERIFY_FAIL);
        }
        String notifyAppId = this.getNotifyAppId(xmlContext);
        if (!MybankConfig.appId.equals(notifyAppId)) {
            throw new MybankApiException(MybankApiExceptionEnum.NOTICE_NOT_MATCH);
        }
    }

    public boolean checkSign(String xmlContext) throws MybankApiException {
        boolean check = false;
        try {
            check = MybankSignature.check(xmlContext, MybankConfig.mybankPublicKey, MybankConfig.charset, MybankConfig.signType);
        }
        catch (MybankApiException e) {
            throw new MybankApiException(e);
        }
        return check;
    }

    public TreeMap<String, String> getNotifyHead(String xmlContext) throws MybankApiException {
        TreeMap<String, String> headMap = new TreeMap<String, String>();
        Document doc = MybankSignature.parseDocumentByString(xmlContext);
        Element root = doc.getDocumentElement();
        Node head = root.getElementsByTagName("head").item(0);
        NodeList childNodes = head.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeType() != 1) continue;
            headMap.put(childNodes.item(i).getNodeName(), childNodes.item(i).getTextContent());
        }
        return headMap;
    }

    public String getNotifyAppId(String xmlContext) throws MybankApiException {
        TreeMap<String, String> notifyHead = this.getNotifyHead(xmlContext);
        String notifyAppId = null;
        notifyAppId = notifyHead.get("Appid");
        if (null == notifyAppId) {
            notifyAppId = notifyHead.get("AppId");
        }
        return notifyAppId;
    }

    public String getNotifyFunction(String xmlContext) throws MybankApiException {
        TreeMap<String, String> notifyHead = this.getNotifyHead(xmlContext);
        return notifyHead.get("Function");
    }

    public String getSignResult(boolean flag, RequestHead head) throws MybankApiException {
        RespInfo respInfo = new RespInfo();
        if (flag) {
            respInfo.setResultCode("0000");
            respInfo.setResultMsg("\u6210\u529f");
            respInfo.setResultStatus("S");
        } else {
            respInfo.setResultCode("9000");
            respInfo.setResultMsg("\u5931\u8d25");
            respInfo.setResultStatus("F");
        }
        BkcloudfundsNotifyResponseBody responseBody = new BkcloudfundsNotifyResponseBody();
        responseBody.setRespInfo(respInfo);
        return this.responseAndSign(head, responseBody);
    }

    public String responseAndSign(RequestHead head, ResponseBody responseBody) throws MybankApiException {
        ResponseHead responseHead = null != head.getAppid() ? ResponseHead.builder(head.getVersion(), head.getAppId(), null, head.getFunction(), head.getReqMsgId()).inputCharset("UTF-8").respTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"))).respTimeZone("UTC+8").reserve("").signType("RSA").build() : ResponseHead.builder(head.getVersion(), head.getAppId(), null, head.getFunction(), head.getReqMsgId()).inputCharset("UTF-8").respTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"))).respTimeZone("UTC+8").reserve("").signType("RSA").build();
        ResponseDocument responseDocument = new ResponseDocument(new Response(responseHead, responseBody));
        DefaultSigner signer = new DefaultSigner(MybankConfig.privateKey);
        String result = null;
        String xml = null;
        try {
            xml = JaxbUtil.convertToXml(responseDocument, "UTF-8");
            result = signer.notifyResponseSign(xml, MybankConfig.charset, MybankConfig.signType);
        }
        catch (MybankApiException e) {
            throw new MybankApiException(e);
        }
        return result;
    }

    public String getNotifyPayResult(boolean flag, RequestHead head) throws MybankApiException {
        BkmerchantSettleNotifyPayResultResponseBody notifyPayResultResponseBody = new BkmerchantSettleNotifyPayResultResponseBody();
        notifyPayResultResponseBody.setIsvOrgId(MybankConfig.isvOrgId);
        if (flag) {
            notifyPayResultResponseBody.setResponseCode("OK");
        } else {
            notifyPayResultResponseBody.setResponseCode("FAIL");
        }
        return this.responseAndSign(head, notifyPayResultResponseBody);
    }
}

