package tk.mybatis.springboot.service;


import cn.hutool.core.lang.Console;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.util.StringUtil;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;
import tk.mybatis.springboot.mapper.HuaWeiSmsTemplateMapper;
import tk.mybatis.springboot.mapper.SmsRecordMapper;
import tk.mybatis.springboot.model.HuaWeiSmsContent;
import tk.mybatis.springboot.model.HuaWeiSmsTemplate;
import tk.mybatis.springboot.model.SmsRecord;
import tk.mybatis.springboot.util.BcxinHttpUtil;
import tk.mybatis.springboot.util.ConfigUtil;

import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.*;

//如果JDK版本是1.8,可使用原生Base64类

@Service
public class HuaWeiSMSSendService {

	@Resource
	private SmsRecordService smsRecordService;

	/**
	 * 验证码类通道
	 */
	private final static String PLAT_SMS_CHANNEL = "8819051615213";

	/**
	 * 通知类通道
	 */
	private final static String BUSINESS_SMS_CHANNEL = "8819051618727";

	//无需修改,用于格式化鉴权头域,给"X-WSSE"参数赋值
	private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
	//无需修改,用于格式化鉴权头域,给"Authorization"参数赋值
	private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";

	@Resource
	private HuaWeiSmsTemplateMapper huaWeiSmsTemplateMapper;

	@Resource
	private SmsRecordMapper smsRecordMapper;

	public void sendSMS(HuaWeiSmsContent huaWeiSmsContent) throws Exception{
		HuaWeiSmsTemplate huaWeiSmsTemplate = huaWeiSmsTemplateMapper.selectTemplateByPlatAndCode(huaWeiSmsContent.getPlatform(),huaWeiSmsContent.getSmsCode());
		if (huaWeiSmsTemplate == null ) {
			return;
		}
		if (StringUtil.isEmpty(huaWeiSmsTemplate.getTemplateCode())) {
			return;
		}
		/* 处理短信内容 */
		JSONArray array = JSON.parseArray(huaWeiSmsContent.getParams());
		Object[] params = array.toArray();
		String content = StrUtil.format(huaWeiSmsTemplate.getTemplateContent(), params);

		/* 如果是带带链接的短信，则发助通 */
		if (huaWeiSmsContent.getPlatform().equals("SAAS") &&
				huaWeiSmsContent.getSmsCode().equals("B05")) {
			SmsRecord smsRecord = new SmsRecord();
			smsRecord.setMobile(huaWeiSmsContent.getMobile());
			smsRecord.setContent(content);
			smsRecord.setPlatform(huaWeiSmsContent.getPlatform());
			smsRecordService.sendZhuTongSMS(smsRecord);
//			smsRecordService.sendWeiLaiSMS(smsRecord);
			return;
		}

		SmsRecord smsRecord = new SmsRecord();
		smsRecord.setContent(content);
		smsRecord.setMobile(huaWeiSmsContent.getMobile());
		smsRecord.setPlatform(huaWeiSmsContent.getPlatform());

		//必填,请参考"开发准备"获取如下数据,替换为实际值
		String url = "https://api.rtc.huaweicloud.com:10443/sms/batchSendSms/v1"; //APP接入地址+接口访问URI
		String appKey = "1dkZb2JPk77EJtdG47BEgUM9evK5"; //APP_Key
		String appSecret = "hIK57pOEA6230iEJrfATH1bAOIOv"; //APP_Secret
		String sender ;
		if (huaWeiSmsContent.getSmsCode().startsWith("P")) {
			sender = PLAT_SMS_CHANNEL;
		} else {
			sender = BUSINESS_SMS_CHANNEL;
		}
		//条件必填,国内短信关注,当templateId指定的模板类型为通用模板时生效且必填,必须是已审核通过的,与模板类型一致的签名名称
		//国际/港澳台短信不用关注该参数
		String signature = "百川信"; //签名名称

		//必填,全局号码格式(包含国家码),示例:+8615123456789,多个号码之间用英文逗号分隔
		//String receiver = "18910027675"; //短信接收人号码
		//String receiver = "18910027675,+8615234567890"; //短信接收人号码

		//选填,短信状态报告接收地址,推荐使用域名,为空或者不填表示不接收状态报告
		String statusCallBack = "";

		/*
		 * 选填,使用无变量模板时请赋空值 String templateParas = "";
		 * 单变量模板示例:模板内容为"您的验证码是${NUM_6}"时,templateParas可填写为"[\"369751\"]"
		 * 双变量模板示例:模板内容为"您有${NUM_2}件快递请到${TXT_32}领取"时,templateParas可填写为"[\"3\",\"人民公园正门\"]"
		 * 查看更多模板格式规范:常见问题>业务规则>短信模板内容审核标准
		 */
		//String templateParas = "[\"888888\"]"; //模板变量

		//请求Body,不携带签名名称时,signature请填null
		String body = buildRequestBody(sender, huaWeiSmsContent.getMobile(), huaWeiSmsTemplate.getTemplateCode(), huaWeiSmsContent.getParams(), statusCallBack, signature);
		System.out.println("华为云返回的参数："+body);
		if (null == body || body.isEmpty()) {
			System.out.println("body is null.");
			return;
		}

		//请求Headers中的X-WSSE参数值
		String wsseHeader = buildWsseHeader(appKey, appSecret);
		if (null == wsseHeader || wsseHeader.isEmpty()) {
			System.out.println("wsse header is null.");
			return;
		}

		//如果JDK版本低于1.8,可使用如下代码
		//为防止因HTTPS证书认证失败造成API调用失败,需要先忽略证书信任问题
		//CloseableHttpClient client = HttpClients.custom()
		//        .setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {
		//            @Override
		//            public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
		//                return true;
		//            }
		//        }).build()).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();

		//如果JDK版本是1.8,可使用如下代码
		//为防止因HTTPS证书认证失败造成API调用失败,需要先忽略证书信任问题
		CloseableHttpClient client = HttpClients.custom()
				.setSSLContext(new SSLContextBuilder().loadTrustMaterial(null,
						(x509CertChain, authType) -> true).build())
				.setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE)
				.build();

		HttpResponse response = client.execute(RequestBuilder.create("POST")//请求方法POST
				.setUri(url)
				.addHeader(HttpHeaders.CONTENT_TYPE, "application/x-www-form-urlencoded")
				.addHeader(HttpHeaders.AUTHORIZATION, AUTH_HEADER_VALUE)
				.addHeader("X-WSSE", wsseHeader)
				.setEntity(new StringEntity(body)).build());

		System.out.println(response.toString()); //打印响应头域信息
		String result = EntityUtils.toString(response.getEntity()); //打印响应消息实体
		System.out.println("华为云返回的参数："+result);
		Map map = JSON.parseObject(result, Map.class);
		String code = map.get("code").toString();
		if ("000000".equals(code)) {
			smsRecord.setSuccess(1);
		} else {
			try {
				String temp = map.get("result").toString();
				if (temp.indexOf("status") > 0) {
					List d = JSON.parseObject(temp, List.class);
					Map<String, String> e = (Map<String, String>) d.get(0);
					smsRecord.setRet(e.get("status"));
				}
			} catch (Exception e) {
				/* 截取失败也不影响保存 */
				//smsRecord.setRet("-1");
				smsRecord.setSuccess(0);
			}
		}
		smsRecord.setChannel("huawei");
		smsRecordMapper.insert(smsRecord);
	}

	public void sendZhuTongSMS(HuaWeiSmsContent huaWeiSmsContent){
		HuaWeiSmsTemplate huaWeiSmsTemplate = huaWeiSmsTemplateMapper.selectTemplateByPlatAndCode(huaWeiSmsContent.getPlatform(),huaWeiSmsContent.getSmsCode());
		if (huaWeiSmsTemplate == null ) {
			System.out.println("============>huaWeiSmsTemplate == null ,huaWeiSmsContent:"+JSON.toJSONString(huaWeiSmsContent));
			return;
		}
		if (StringUtil.isEmpty(huaWeiSmsTemplate.getTemplateCode())) {
			System.out.println("============>huaWeiSmsTemplate.getTemplateCode() == null ,huaWeiSmsContent:"+JSON.toJSONString(huaWeiSmsContent));
			return;
		}
		/* 处理短信内容 */
		JSONArray array = JSON.parseArray(huaWeiSmsContent.getParams());
		Object[] params = array.toArray();
		String content = StrUtil.format(huaWeiSmsTemplate.getTemplateContent(), params);

		SmsRecord smsRecord = new SmsRecord();
		smsRecord.setMobile(huaWeiSmsContent.getMobile());
		smsRecord.setContent(content);
		smsRecord.setPlatform(huaWeiSmsContent.getPlatform());
		/* 测试环境不发短信 */
		if ("test".equals(huaWeiSmsContent.getEnvi())) {
			smsRecord.setSuccess(0);
			smsRecordMapper.insert(smsRecord);
		} else {
			if ("beijing".equalsIgnoreCase(huaWeiSmsContent.getChannel())
					&& "on".equals(ConfigUtil.getValue("switch_beijing_channel"))) {
				boolean beijingSendSuccess = smsRecordService.sendBeijingSMS(smsRecord);
				/* 如果北京通道发送失败，则换其他渠道发送 */
				if (!beijingSendSuccess) {
					smsRecordService.sendZhuTongSMS(smsRecord);
//					smsRecordService.sendWeiLaiSMS(smsRecord);
				}
			} else {
				smsRecordService.sendZhuTongSMS(smsRecord);
//				smsRecordService.sendWeiLaiSMS(smsRecord);
			}
		}
	}


	/**
	 * 构造请求Body体
	 * @param sender
	 * @param receiver
	 * @param templateId
	 * @param templateParas
	 * @param statusCallbackUrl
	 * @param signature | 签名名称,使用国内短信通用模板时填写
	 * @return
	 */
	static String buildRequestBody(String sender, String receiver, String templateId, String templateParas,
								   String statusCallbackUrl, String signature) {
		if (null == sender || null == receiver || null == templateId || sender.isEmpty() || receiver.isEmpty()
				|| templateId.isEmpty()) {
			System.out.println("buildRequestBody(): sender, receiver or templateId is null.");
			return null;
		}
		List<NameValuePair> keyValues = new ArrayList<NameValuePair>();

		keyValues.add(new BasicNameValuePair("from", sender));
		keyValues.add(new BasicNameValuePair("to", receiver));
		keyValues.add(new BasicNameValuePair("templateId", templateId));
		if (null != templateParas && !templateParas.isEmpty()) {
			keyValues.add(new BasicNameValuePair("templateParas", templateParas));
		}
		if (null != statusCallbackUrl && !statusCallbackUrl.isEmpty()) {
			keyValues.add(new BasicNameValuePair("statusCallback", statusCallbackUrl));
		}
		if (null != signature && !signature.isEmpty()) {
			keyValues.add(new BasicNameValuePair("signature", signature));
		}

		return URLEncodedUtils.format(keyValues, Charset.forName("UTF-8"));
	}

	/**
	 * 构造X-WSSE参数值
	 * @param appKey
	 * @param appSecret
	 * @return
	 */
	static String buildWsseHeader(String appKey, String appSecret) {
		if (null == appKey || null == appSecret || appKey.isEmpty() || appSecret.isEmpty()) {
			System.out.println("buildWsseHeader(): appKey or appSecret is null.");
			return null;
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
		String time = sdf.format(new Date()); //Created
		String nonce = UUID.randomUUID().toString().replace("-", ""); //Nonce

		byte[] passwordDigest = DigestUtils.sha256(nonce + time + appSecret);
		String hexDigest = Hex.encodeHexString(passwordDigest);

		//如果JDK版本是1.8,请加载原生Base64类,并使用如下代码
		String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes()); //PasswordDigest
		//如果JDK版本低于1.8,请加载三方库提供Base64类,并使用如下代码
		//String passwordDigestBase64Str = Base64.encodeBase64String(hexDigest.getBytes(Charset.forName("utf-8"))); //PasswordDigest
		//若passwordDigestBase64Str中包含换行符,请执行如下代码进行修正
		//passwordDigestBase64Str = passwordDigestBase64Str.replaceAll("[\\s*\t\n\r]", "");

		return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
	}


	public void resent(){
		//List<SmsRecord> list = smsRecordMapper.selectRows();
		List<String> list = Lists.newArrayList("18910027675");
		//List<String> list = Lists.newArrayList("18910027675");
		Map<String,String> map = new HashMap<String,String>();

		System.out.println(list.size());
		int size = 0;
		for (String sms:list) {
			//if (map.get(sms.getMobile())!=null) {
			//	continue;
			//}
			size++;
			Console.log("还剩:"+(list.size()-size));
			//String aaaa = sms.getContent();
			//String company = aaaa.substring(0,aaaa.indexOf("已将您加入公司"));
			//String code = aaaa.substring(aaaa.indexOf("密码为")+3,aaaa.indexOf("，请下载北京"));
			String[] param = new String[]{"第一个参数","第二个参数","第三个参数","第四个参数","第五个参数","第六个参数","第七个参数","第八个参数"};
			HuaWeiSmsContent huawei = new HuaWeiSmsContent();
			huawei.setParams(JSON.toJSONString(param));
			huawei.setPlatform("ARS");
			huawei.setSmsCode("B66");
			huawei.setMobile("18910027675");

			//String aaaa = sms.getContent();
			//String company = aaaa.substring(aaaa.indexOf("请于")+2,aaaa.indexOf("前到"));
			//String code = aaaa.substring(aaaa.indexOf("前到")+2,aaaa.indexOf("参加考试"));
			//String[] param = new String[]{company,code};
			//HuaWeiSmsContent huawei = new HuaWeiSmsContent();
			//huawei.setParams(JSON.toJSONString(param));
			//huawei.setPlatform("ARS");
			//huawei.setSmsCode("B79");
			//huawei.setMobile(sms.getMobile());
			try {
				sendSMS(huawei);
				//String url = "http://msg.bcxin.com.cn:9165/sms/huawei/sendSMS";
				//List<NameValuePair> params = Lists.newArrayList();
				//params.add(new BasicNameValuePair("data", JSON.toJSONString(huawei)));
				//params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN" + "18910027675" + DateUtil.today())));
				//String aa = BcxinHttpUtil.sendPostRequest(url, params);
				//Console.log(aa);
			} catch (Exception e) {

			}
		}
	}

	public static void main(String[] args) {
		//String aaaa ="北京中保伟业保安服务有限公司已将您加入公司，账号为当前手机号，密码为483298，请下载北京保安App：https://dwz.cn/r5A0P5jE，并完成初始化";
		//String company = aaaa.substring(0,aaaa.indexOf("已将您加入公司"));
		//String code = aaaa.substring(aaaa.indexOf("密码为")+3,aaaa.indexOf("，请下载北京"));
		//Console.log(company);
		//Console.log(code);
		//String aaaa ="您报名的保安资格证考试已安排，请于2019-09-20 13:00:00前到北京市大兴区黄村镇后辛庄永华路2号（大兴一职院内）参加考试";
		//String company = aaaa.substring(aaaa.indexOf("请于")+2,aaaa.indexOf("前到"));
		//String code = aaaa.substring(aaaa.indexOf("前到")+2,aaaa.indexOf("参加考试"));
		//Console.log(company);
		//Console.log(code);

		String[] param = new String[]{"第一个参数","第二个参数","第三个参数","第四个参数","第五个参数","第六个参数","第七个参数","第八个参数"};
		Console.log(JSON.toJSONString(param));
		HuaWeiSmsContent huawei = new HuaWeiSmsContent();
		huawei.setParams(JSON.toJSONString(param));
		huawei.setPlatform("ARS");
		huawei.setSmsCode("B66");
		huawei.setMobile("18910027675");

		//String url = "http://msg.bcxin.com.cn:9165/sms/huawei/sendSMS";
		//List<NameValuePair> params = Lists.newArrayList();
		//params.add(new BasicNameValuePair("data", JSON.toJSONString(huawei)));
		//params.add(new BasicNameValuePair("token", MD5Util.string2MD5("BCXIN" + "18910027675" + DateUtil.today())));
		//String aa = BcxinHttpUtil.sendPostRequest(url, params);
		//Console.log(aa);

		String url = "http://218.205.176.198:8089/sms/sms/sendMsg";
		List<NameValuePair> params = Lists.newArrayList();
		params.add(new BasicNameValuePair("phonenumber", "15259247525"));
		params.add(new BasicNameValuePair("content", "2您参加的保安员资格证考试，考试已安排！理论考试时间：2018年05月15日 15:00到 16:30,考点：市公安局桃花湾办公区广场环路1号"));
		String responseStr = BcxinHttpUtil.sendPostRequest(url, params);
		Map<String,Object> responseMap = JSON.parseObject(responseStr, Map.class);
		System.out.println(responseMap.get("code").toString());
	}
}
