package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import lombok.Getter;

@Getter
public class OrganizationCreatedEvent extends DomainEventAbstract<OrganizationEntity> {
    private final String name;

    /**
     * 组织Id
     * @param organization
     * @param name
     */
    public OrganizationCreatedEvent(OrganizationEntity organization, String name) {
        super(organization);
        this.name = name;
    }

    public static OrganizationCreatedEvent create(OrganizationEntity organization, String name)
    {
        return new OrganizationCreatedEvent(organization, name);
    }
}
