package com.bcxin.tenant.domain.entities.valueTypes;

import com.bcxin.Infrastructures.entities.ValueType;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.sql.Timestamp;
import java.time.Instant;

@Getter
@Setter(AccessLevel.PROTECTED)
@Embeddable
public class ApprovedInformationValueType extends ValueType {
    /**
     * 审批状态
     */
    @Column(nullable = false)
    private ApprovedStatus status;
    /**
     * 审批修改时间
     */
    @Column(name = "last_updated_time")
    private Timestamp lastUpdatedTime;
    /**
     * 意见
     */
    @Column(name = "note",length = 500)
    private String note;

    protected ApprovedInformationValueType(){
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public static ApprovedInformationValueType create(ApprovedStatus status,String note) {
        ApprovedInformationValueType approvedInformation = new ApprovedInformationValueType();
        approvedInformation.setStatus(status);
        approvedInformation.setNote(note);

        return approvedInformation;
    }
}
