package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

/**
 * @description 工资计算记录
 */
@Entity
@Data
@Table(name="salary_statistics")
public class SalaryStatistics implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    /**
    * id
    */
    @Column(name="id")
    private Long id;

    /**
    * 应发工资
    */
    @Column(name="should_salary")
    private BigDecimal shouldSalary;

    /**
    * 月份 202106 
    */
    @Column(name="month")
    private String month;

    /**
    * 实发工资
    */
    @Column(name="actual_salary")
    private BigDecimal actualSalary;

    /**
    * 个税总额
    */
    @Column(name="tax")
    private BigDecimal tax;

    /**
    * 创建时间
    */
    @Column(name="create_time",insertable = false)
    private Date createTime;

    /**
    * 更新时间
    */
    @Column(name="update_time", updatable = false)
    private Date updateTime;

    /**
    * 薪资表名称 
    */
    @Column(name="tab_name")
    private String tabName;

    /**
    * 计薪总人数
    */
    @Column(name="total_person_count")
    private Integer totalPersonCount;

    /**
    * 薪资锁定时间
    */
    @Column(name="lock_time")
    private Date lockTime;

    public SalaryStatistics() {
    }

}
