package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

@Entity
@Data
@Table(name="salary_group_user")
public class SalaryGroupUser implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    /**
    * id
    */
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    private Long id;

    /**
    * 薪资组名称  
    */
    @Column(name="group_name")
    private String groupName;

    /**
    * 薪资组id
    */
    @Column(name="group_id")
    private Long groupId;

    /**
    * 工号  
    */
    @Column(name="employee_no")
    private String employeeNo;

    /**
    * 姓名  
    */
    @Column(name="name")
    private String name;

    /**
    * 部门ID
    */
    @Column(name="dept_id")
    private String deptId;

    /**
    * 创建时间
    */
    @Column(name="create_time", insertable = false)
    private Date createTime;

    /**
    * 更改时间
    */
    @Column(name="update_time", updatable = false)
    private Date updateTime;

    public SalaryGroupUser() {
    }

}
