package com.bcxin.tenant.domain.entities;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

/**
 * @description salary_change_record
 * @author james
 */

@Entity
@Data
@Table(name="salary_change_record")
public class SalaryChangeRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    /**
    * id
    */
    @Column(name="id")
    private Long id;
    
    /**
    * 机构ID
    */
    @Column(name="orgId")
    private String orgId;

    /**
    * 员工号
    */
    @Column(name="employee_no")
    private String employeeNo;

    /**
    * 员工名字 collate utf8mb4_unicode_ci
    */
    @Column(name="name")
    private String name;


    /**
    * 定调薪类型 1 定薪 2 调薪
    */
    @Column(name="type")
    private Integer type;

    /**
    * 原因 collate utf8mb4_unicode_ci
    */
    @Column(name="remark")
    private String remark;

    /**
    * 创建时间
    */
    @Column(name="create_time", insertable = false)
    private Date createTime;

    /**
    * 生效时间
    */
    @Column(name="valid_time")
    private Date validTime;

    /**
    * 生效状态
    */
    @Column(name="valid_state")
    private Integer validState;

    /**
    * 经办人id
    */
    @Column(name="handler")
    private String handler;

    /**
    * 经办人 collate utf8mb4_unicode_ci
    */
    @Column(name="handler_name")
    private String handlerName;

    /**
    * 状态 0 撤销 1 正常
    */
    @Column(name="state")
    private Integer state;

    /**
    * 定调薪其他项
    */
    @Column(name="other_item")
    private String otherItem;

    public SalaryChangeRecord() {
    }

}