package com.bcxin.tenant.domain.entities;


import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import lombok.Data;

/**
 * <p>
 * 薪资档案
 * </p>
 *
 * @author James
 * @since 2021-12-16
 */
@Entity
@Data
public class SalaryArchive implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)//主键生成策略
    /**
    * id
    */
    private Long id;

    /**
    * 员工号
    */
    private String employeeNo;
    /**
     * 组织ID
     */
    private String orgId;

    /**
    * 姓名 
    */
    private String name;


    /**
    * 定调薪状态 0未定薪、1 已定薪、2已调薪
    */
    private Integer changeState;


    /**
    * 创建时间
    */
    @Column(insertable = false)
    private Date createTime;
    /**
    * 生效时间
    */
    @Column(name="valid_time")
    private Date validTime;

    /**
    * 生效状态
    */
    @Column(name="valid_state")
    private Integer validState;
    
    /**
    * 定调薪其他项
    */
    @Column(name="other_item")
    private String otherItem;

    /**
    * 更新时间
    */
    @Column(updatable  = false)
    private Date updateTime;
    
    public SalaryArchive() {}
}
