package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "tenant_companies")
@Entity
public class CompanyEntity extends EntityAbstract {

    @Id
    private String id;

    @Column(name = "unify_social_credit_code", nullable = false)
    private String unifySocialCreditCode;

    @Column(name = "unify_social_credit_code_file", nullable = false)
    private String unifySocialCreditCodeFile;

    protected CompanyEntity() {
        super();
    }

    protected CompanyEntity(OrganizationEntity organization,
                            String unifySocialCreditCode, String unifySocialCreditCodeFile) {
        this.setUnifySocialCreditCode(unifySocialCreditCode);
        this.setUnifySocialCreditCodeFile(unifySocialCreditCodeFile);
        this.setId(organization.getId());
    }

    public void change(String unifySocialCreditCode, String unifySocialCreditCodeFile) {
        this.setUnifySocialCreditCodeFile(unifySocialCreditCodeFile);
        this.setUnifySocialCreditCode(unifySocialCreditCode);
    }

    public static CompanyEntity create(OrganizationEntity organization,
                                       String unifySocialCreditCode, String unifySocialCreditCodeFile) {
        CompanyEntity company = new CompanyEntity(organization, unifySocialCreditCode, unifySocialCreditCodeFile);

        return company;
    }
}
