package com.bcxin.wps.repository.impls;

import com.bcxin.wps.entity.User;
import com.bcxin.wps.repository.UserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Component
public class UserRepositoryImpl implements UserRepository {
    private static final Logger logger = LoggerFactory.getLogger(UserRepositoryImpl.class);

    private static List<Long> __static_users = Stream.of(1l,2l).collect(Collectors.toList());
    @Override
    public List<User> findAllById(Collection<Long> longs) {
        List<User> users = __static_users.stream().filter(ii -> longs.contains(ii))
                .map(ii -> User.builder().id(ii).nickname(String.format("Hello-%s", ii)).build())
                .collect(Collectors.toList());

        logger.error("User.findAllById :{};信息={};", longs.stream().map(ii -> String.valueOf(ii)).collect(Collectors.joining(",")),
                CollectionUtils.isEmpty(users) ? "NULL" : users.size());

        return users;
    }

    @Override
    public Optional<User> findById(Long aLong) {
        Optional<User> selectedUserOptional =
                __static_users.stream().filter(ii -> ii.equals(aLong))
                        .map(ii -> User.builder().id(ii).nickname(String.format("Hello-%s", ii)).build())
                        .findFirst();

        logger.error("获取到的当前用户为:{};信息={};",aLong, selectedUserOptional.isPresent() ? selectedUserOptional.get().getNickname() : "NULL");

        return selectedUserOptional;
    }

    @Override
    public <S extends User> S save(S entity) {
        logger.error("UserRepositoryImpl-用户信息保存成功:{};name={};", entity.getId(), entity.getNickname());

        __static_users.add(entity.getId());

        return entity;
    }
}
