package com.bcxin.utils;

import lombok.Data;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Data
@Component
public class ConfigUtil {

	private static Map<String, String> data = new HashMap<String, String>();
	
	public static String getValue(String key) {
		String value = data.get(key.toLowerCase());
		if ( "material_path".equalsIgnoreCase(key)) {
			//如果是windows，增加盘符
			String os = System.getProperty("os.name");
			if (os.toLowerCase().startsWith("win")) {
				if (value.startsWith("/")) {
					value = "D:" + value;
				}
			}
		}
		return value;
	}

	public static void putValue(String key,String value) {
		data.put(key, value);
	}

	public static Map<String, String> getData() {
		return data;
	}
	
}
