package com.bcxin.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.dao.XfileMapper;
import com.bcxin.model.domain.Xfile;
import com.bcxin.service.IXfileService;
import com.bcxin.utils.DocConverter;
import com.bcxin.utils.constant.Const;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.io.Files;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * </p>
 *
 * @author 罗鹏
 * @date 2018/3/14
 */
@Service("xfileService")
public class XfileService extends ServiceImpl<XfileMapper, Xfile> implements IXfileService {

    @Autowired
    private RedissonClient redissonClient;

    private Xfile selectByFileUrl(String fileUrl) {
        return this.getOne(new QueryWrapper<Xfile>().eq("fileUrl", fileUrl));
    }

    @Override
    public String  preview(String subject){
        Map<String, String> paramMap = JSON.parseObject(subject, new TypeReference<HashMap<String, String>>(){ });
        String fileUrl = paramMap.get("fileUrl");

        if (StrUtil.isEmpty(fileUrl) ) {
           return null;
        }

        //if (!fileUrl.startsWith(Const.FILEURL_PREFIX)) {
        //    return null;
        //}

        return fileUrl;
    }


    @Override
    public String convert(String subject) {
        //Map<Object,Object> resultMap = Maps.newHashMap();
        Map<String, String> paramMap = JSON.parseObject(subject, new TypeReference<HashMap<String, String>>(){ });

        String fileUrl = paramMap.get("fileUrl");
        //String resume = paramMap.get("resume");
        //String callback = paramMap.get("callback");
        //String extra = paramMap.get("extra");

        /*先查询该url是否已经转了，如果已经转了，则取数据库中的值*/
        Xfile xfile = selectByFileUrl(fileUrl);
        /*之前已经进行转换*/
        if (xfile != null) {
            return xfile.getPdfUrl();
            //String token = JwtUtil.createJWT(resultMap, ConfigUtil.getValue("jwt_key"),JwtUtil.JWT_REFRESH_TTL);//加密生成token
            //HttpUtil.post(callback, token);
            //return;
        }


        DocConverter d = new DocConverter();
        d.init(fileUrl);
        d.convert();

        Xfile xfile1 = new Xfile();
        xfile1.setOid(IdWorker.getId());
        xfile1.setFilename(d.getSourceFileName());
        xfile1.setPdfUrl(Const.ZIP_FILE_LIST.contains(Files.getFileExtension(fileUrl))?d.getHttpZipFile():d.getHttpPdfFile());
        xfile1.setFileUrl(fileUrl);
        xfile1.setCreateOn(new Date());
        this.save(xfile1);

        return xfile1.getPdfUrl();

        ///* 回调第三方*/
        //resultMap.put("status", Const.HTTP_STATUS_OK);
        //resultMap.put("newUrl", doc.getPdfUrl());
        //resultMap.put("previewUrl", doc.getPreviewUrl());
        //resultMap.put("extra", extra);
        //String token = JwtUtil.createJWT(resultMap,ConfigUtil.getValue("jwt_key"),JwtUtil.JWT_REFRESH_TTL);//加密生成token
        //HttpUtil.post(callback, token);

        //transaction.setIsSync(Const.Y);
        //transaction.setFinishTime(new Date());
        //transaction.setResponseMessage(resultMap.toString());
        //
        //transactionMapper.update(transaction,new EntityWrapper<Transaction>());

    }
}
