package com.bcxin.service.impl;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.model.FileAttribute;
import com.bcxin.model.ReturnResponse;
import com.bcxin.service.IFilePreview;
import com.bcxin.utils.ConfigUtil;
import com.bcxin.utils.DownloadUtils;
import com.bcxin.utils.FileUtils;
import com.bcxin.utils.ZipReader;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;

/**
 * Created by kl on 2018/1/17.
 * Content :处理压缩包文件
 */
@Service
@Slf4j
public class CompressIFilePreviewImpl implements IFilePreview {

    @Resource
    private FileUtils fileUtils;

    @Resource
    private DownloadUtils downloadUtils;

    @Resource
    private ZipReader zipReader;

    @Override
    public String filePreviewHandle(String url, Model model) {
        log.info("CompressIFilePreviewImpl=>filePreviewHandle=>url："+url);
        FileAttribute fileAttribute=fileUtils.getFileAttribute(url);
        String fileName = fileAttribute.getName();
        String decodedUrl = fileAttribute.getDecodedUrl();
        String suffix = fileAttribute.getSuffix();
        String fileTree = null;
        // 判断文件名是否存在(redis缓存读取)
        if (!StringUtils.hasText(fileUtils.getConvertedFile(fileName))) {
            log.info("CompressIFilePreviewImpl=>filePreviewHandle=>FileAttribute："+ JSON.toJSONString(fileAttribute));
            ReturnResponse<String> response = downloadUtils.downLoad(decodedUrl, suffix, fileName);
            log.info("CompressIFilePreviewImpl=>filePreviewHandle=>ReturnResponse："+ JSON.toJSONString(response));
            if (0 != response.getCode()) {
                model.addAttribute("msg", response.getMsg());
                return "fileNotSupported";
            }
            String filePath = response.getContent();
            if ("zip".equalsIgnoreCase(suffix) || "jar".equalsIgnoreCase(suffix) || "gzip".equalsIgnoreCase(suffix)) {
                try {
                    fileTree = zipReader.readZipFile(filePath, fileName);
                } catch (Exception e){
                    log.info("CompressIFilePreviewImpl=>filePreviewHandle=>Exception.1："+ e.getMessage());
                    if("zip".equalsIgnoreCase(suffix)){
                        try {
                            String newFile = filePath.replace(".zip",".rar");
                            FileUtil.copy(filePath,filePath.replace(".zip",".rar"),true);
                            fileTree = zipReader.unRar(newFile, fileName.replace(".zip",".rar"));
                        }catch(Exception ex){
                            log.info("CompressIFilePreviewImpl=>filePreviewHandle=>Exception.2："+ ex.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
            } else if ("rar".equalsIgnoreCase(suffix)) {
                fileTree = zipReader.unRar(filePath, fileName);
            }
            fileUtils.addConvertedFile(fileName, fileTree);
            log.info("CompressIFilePreviewImpl=>filePreviewHandle=>addConvertedFile：end！");
        } else {
            fileTree = fileUtils.getConvertedFile(fileName);
        }
        log.info("CompressIFilePreviewImpl=>filePreviewHandle=>fileTree："+fileTree);
        if (null != fileTree) {
            model.addAttribute("fileTree", fileTree);
            return "compress";
        } else {
            model.addAttribute("msg", "压缩文件类型不受支持，尝试在压缩的时候选择RAR4格式");
            return "fileNotSupported";
        }
    }
}
