/*
 * Decompiled with CFR 0.152.
 */
package cn.wps.solution.weboffice.provider.v3.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Watermark {
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="value")
    private String value;
    @JsonProperty(value="fill_style")
    private FillStyle fillStyle;
    @JsonProperty(value="font")
    private String font;
    @JsonProperty(value="rotate")
    private double rotate;
    @JsonProperty(value="horizontal")
    private int horizontal;
    @JsonProperty(value="vertical")
    private int vertical;

    public static WatermarkBuilder builder() {
        return new WatermarkBuilder();
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public String getFont() {
        return this.font;
    }

    public double getRotate() {
        return this.rotate;
    }

    public int getHorizontal() {
        return this.horizontal;
    }

    public int getVertical() {
        return this.vertical;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="fill_style")
    public void setFillStyle(FillStyle fillStyle) {
        this.fillStyle = fillStyle;
    }

    @JsonProperty(value="font")
    public void setFont(String font) {
        this.font = font;
    }

    @JsonProperty(value="rotate")
    public void setRotate(double rotate) {
        this.rotate = rotate;
    }

    @JsonProperty(value="horizontal")
    public void setHorizontal(int horizontal) {
        this.horizontal = horizontal;
    }

    @JsonProperty(value="vertical")
    public void setVertical(int vertical) {
        this.vertical = vertical;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Watermark)) {
            return false;
        }
        Watermark other = (Watermark)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getRotate(), other.getRotate()) != 0) {
            return false;
        }
        if (this.getHorizontal() != other.getHorizontal()) {
            return false;
        }
        if (this.getVertical() != other.getVertical()) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        FillStyle this$fillStyle = this.getFillStyle();
        FillStyle other$fillStyle = other.getFillStyle();
        if (this$fillStyle == null ? other$fillStyle != null : !this$fillStyle.equals(other$fillStyle)) {
            return false;
        }
        String this$font = this.getFont();
        String other$font = other.getFont();
        return !(this$font == null ? other$font != null : !this$font.equals(other$font));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Watermark;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $rotate = Double.doubleToLongBits(this.getRotate());
        result = result * 59 + (int)($rotate >>> 32 ^ $rotate);
        result = result * 59 + this.getHorizontal();
        result = result * 59 + this.getVertical();
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        FillStyle $fillStyle = this.getFillStyle();
        result = result * 59 + ($fillStyle == null ? 43 : $fillStyle.hashCode());
        String $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        return result;
    }

    public String toString() {
        return "Watermark(type=" + (Object)((Object)this.getType()) + ", value=" + this.getValue() + ", fillStyle=" + this.getFillStyle() + ", font=" + this.getFont() + ", rotate=" + this.getRotate() + ", horizontal=" + this.getHorizontal() + ", vertical=" + this.getVertical() + ")";
    }

    public Watermark() {
    }

    public Watermark(Type type, String value, FillStyle fillStyle, String font, double rotate, int horizontal, int vertical) {
        this.type = type;
        this.value = value;
        this.fillStyle = fillStyle;
        this.font = font;
        this.rotate = rotate;
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    public static class WatermarkBuilder {
        private Type type;
        private String value;
        private FillStyle fillStyle;
        private String font;
        private double rotate;
        private int horizontal;
        private int vertical;

        WatermarkBuilder() {
        }

        @JsonProperty(value="type")
        public WatermarkBuilder type(Type type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="value")
        public WatermarkBuilder value(String value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="fill_style")
        public WatermarkBuilder fillStyle(FillStyle fillStyle) {
            this.fillStyle = fillStyle;
            return this;
        }

        @JsonProperty(value="font")
        public WatermarkBuilder font(String font) {
            this.font = font;
            return this;
        }

        @JsonProperty(value="rotate")
        public WatermarkBuilder rotate(double rotate) {
            this.rotate = rotate;
            return this;
        }

        @JsonProperty(value="horizontal")
        public WatermarkBuilder horizontal(int horizontal) {
            this.horizontal = horizontal;
            return this;
        }

        @JsonProperty(value="vertical")
        public WatermarkBuilder vertical(int vertical) {
            this.vertical = vertical;
            return this;
        }

        public Watermark build() {
            return new Watermark(this.type, this.value, this.fillStyle, this.font, this.rotate, this.horizontal, this.vertical);
        }

        public String toString() {
            return "Watermark.WatermarkBuilder(type=" + (Object)((Object)this.type) + ", value=" + this.value + ", fillStyle=" + this.fillStyle + ", font=" + this.font + ", rotate=" + this.rotate + ", horizontal=" + this.horizontal + ", vertical=" + this.vertical + ")";
        }
    }

    public static class FillStyle {
        private int red;
        private int green;
        private int blue;
        private double alpha;

        @JsonValue
        public String jsonValue() {
            return String.format("rgba( %d, %d, %d, %f)", this.red, this.green, this.blue, this.alpha);
        }

        FillStyle(int red, int green, int blue, double alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public static FillStyleBuilder builder() {
            return new FillStyleBuilder();
        }

        public static class FillStyleBuilder {
            private int red;
            private int green;
            private int blue;
            private double alpha;

            FillStyleBuilder() {
            }

            public FillStyleBuilder red(int red) {
                this.red = red;
                return this;
            }

            public FillStyleBuilder green(int green) {
                this.green = green;
                return this;
            }

            public FillStyleBuilder blue(int blue) {
                this.blue = blue;
                return this;
            }

            public FillStyleBuilder alpha(double alpha) {
                this.alpha = alpha;
                return this;
            }

            public FillStyle build() {
                return new FillStyle(this.red, this.green, this.blue, this.alpha);
            }

            public String toString() {
                return "Watermark.FillStyle.FillStyleBuilder(red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + ")";
            }
        }
    }

    public static enum Type {
        NONE,
        TEXT;


        @JsonValue
        public int jsonValue() {
            return this.ordinal();
        }
    }
}

