package com.bcxin.platform.service.wallet;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.dto.order.ComOrderPayDTO;

/**
 * 企业钱包服务
 *
 * @author llc
 * @date 2019-06-21
 */
public interface ComWalletPaymentService {

    /**
     * 支付校验
     *
     * @param dto
     * @return
     * @throws V5BusinessException
     */
    Result payValidate(ComOrderPayDTO dto) throws V5BusinessException;

    /**
     * 获得支付手机号
     *
     * @param dto
     * @return
     * @throws V5BusinessException
     */
    Result getPayPhone(ComOrderPayDTO dto) throws V5BusinessException;

    /**
     * 给订单发送支付验证码
     *
     * @param dto
     * @return
     * @throws V5BusinessException
     */
    Result sendPayVerifyCode(ComOrderPayDTO dto) throws V5BusinessException;

    /**
     * 实际支付接口
     *
     * @param dto
     * @return
     * @throws V5BusinessException
     */
    Result actualPay(ComOrderPayDTO dto);

}