package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendClockDetail;

/**
 * 考勤打卡记录Service接口
 * 
 * @author lin
 * @date 2021-08-27
 */
public interface AttendClockDetailService {

    /**
     * 查询考勤打卡记录
     * 
     * @param id 考勤打卡记录ID
     * @return 考勤打卡记录
     */
    AttendClockDetail findById(Long id);

    /**
     * 编辑考勤打卡记录
     * 
     * @param attendClockDetail 考勤打卡记录
     * @return 结果
     */
    int update(AttendClockDetail attendClockDetail);

    /**
     * 批量删除考勤打卡记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除考勤打卡记录信息
     * 
     * @param id 考勤打卡记录ID
     * @return 结果
     */
    int deleteById(Long id);
}
