package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendSchedulConflictDetail;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤排班冲突关联关系Mapper接口
 * 
 * @author lin
 * @date 2022-02-14
 */
public interface AttendSchedulConflictDetailMapper{

    /**
     * 查询考勤排班冲突关联关系
     * 
     * @param id 考勤排班冲突关联关系ID
     * @return 考勤排班冲突关联关系
     */
    AttendSchedulConflictDetail findById(Long id);

    /**
     * 查询考勤排班冲突关联关系列表
     * 
     * @param attendSchedulConflictDetail 考勤排班冲突关联关系
     * @return 考勤排班冲突关联关系集合
     */
    List<AttendSchedulConflictDetail> selectList(AttendSchedulConflictDetail attendSchedulConflictDetail);

    /**
     * 删除考勤排班冲突关联关系
     * 
     * @param id 考勤排班冲突关联关系ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤排班冲突关联关系
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendSchedulConflictDetail
     * @return
     */
    int save(AttendSchedulConflictDetail attendSchedulConflictDetail);

    /****
     * 选择修改
     * @param attendSchedulConflictDetail
     * @return
     */
    int updateSelective(AttendSchedulConflictDetail attendSchedulConflictDetail);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendSchedulConflictDetail> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendSchedulConflictDetail> findByBatchId(@Param("list") List<AttendSchedulConflictDetail> list);

}
