package com.bcxin.platform.dto.wallet;

import com.bcxin.platform.domain.wallet.ComWalletTrade;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业钱包账户交易dto
 *
 * @author lp
 * @date 2019-09-04
 */
@Data
public class ComWalletTradeDTO extends ComWalletTrade {

    /**
     * 交易流水号
     */
    private String tradeFlowNo;

    /**
     * 开始日期
     */
    private String startDate;

    /**
     * 结束日期
     */
    private String endDate;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 资金流向
     */
    private String fundFlowType;

    /**
     * 银行交易类型
     */
    @ApiModelProperty(value = "银行交易类型")
    private String bankTradeType;

}
