package com.bcxin.platform.dto;

import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.servlet.http.HttpServletRequest;

/**
 * 当前用户登陆信息
 * 
 * @author zhangye
 *
 */
@Data
public class CurrentUser {
	/**
	 * 公司ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long comId;
	/**
	 * 用户ID
	 */
	@JsonSerialize(using = LongJsonSerializer.class)
	@JsonDeserialize(using = LongJsonDeserializer.class)
	private Long perId;

	public CurrentUser(HttpServletRequest request) {
		this.comId = (request.getAttribute("comId") == null || request.getAttribute("comId").equals("")) ? null
				: Long.valueOf(request.getAttribute("comId").toString());
		this.perId = (request.getAttribute("perId") == null || request.getAttribute("perId").equals("")) ? null
				: Long.valueOf(request.getAttribute("perId").toString());
	}


}
