package com.bcxin.obpm.mapper;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;
import com.bcxin.obpm.domain.ObpmUser;
import org.springframework.stereotype.Component;

/**
 * v5用户Mapper接口
 * 
 * @author lin
 * @date 2021-06-06
 */
@Component
public interface ObpmUserMapper{

    /**
     * 查询v5用户
     * 
     * @param ID v5用户ID
     * @return v5用户
     */
    ObpmUser selectObpmUserById(String ID);

    /**
     * 查询v5用户列表
     * 
     * @param tlkComId v5公司id
     * @return v5用户集合
     */
    List<ObpmUser> selectObpmUserList(String tlkComId);

    /**
     * <b> 修改人员当前在保状态 </b>
     * @author ZXF
     * @create 2022/05/25 0025 10:59
     * @version
     * @注意事项 </b>
     */
    int updateInsureByIds(@Param("insure") String insure, @Param("list") List<String> list);
    int updateInsureByIdcardNos(@Param("insure") String insure, @Param("policyNo") String policyNo, @Param("tlkProjectId") String tlkProjectId, @Param("list") List<Map> list);
    int updateUnInsureByPolicyNos(@Param("insure") String insure, @Param("list") List list);
    String getProjectInsureUrl(@Param("tlkProjectId") String tlkProjectId);
    int updateProjectInsureUrl(@Param("tlkProjectId") String tlkProjectId, @Param("piUrl") String piUrl);
}
