/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.util.file.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.bcxin.platform.util.constants.Constants;
import com.bcxin.platform.util.file.oss.OSSResultInfo;
import com.bcxin.platform.util.file.oss.OSSResultObject;
import com.bcxin.platform.util.file.oss.OSSService;
import com.bcxin.platform.util.file.oss.OSSUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSServiceExecutor
implements OSSService {
    private String server;
    private String bucketName;
    private final String PROTOCOL_STRING = Protocol.HTTP + "://";
    private static final Logger logger = LoggerFactory.getLogger(OSSServiceExecutor.class);

    public OSSServiceExecutor(String envi) {
        if (Objects.equals(envi, "PASP-QY")) {
            this.server = this.PROTOCOL_STRING + Constants.OSS_BUCKETNAME_PROD + "." + Constants.OSS_SERVERADDRESSS + "/";
            this.bucketName = Constants.OSS_BUCKETNAME_PROD;
        } else {
            this.server = this.PROTOCOL_STRING + Constants.OSS_BUCKETNAME_TEST + "." + Constants.OSS_SERVERADDRESSS + "/";
            this.bucketName = Constants.OSS_BUCKETNAME_TEST;
        }
    }

    @Override
    public OSSClient getClient() {
        return new OSSClient(Constants.OSS_SERVERADDRESSS, Constants.OSS_ACCESSID, Constants.OSS_ACCESSKEY);
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public void createDirectory(String directoryName) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(0L);
        byte[] buffer = new byte[]{};
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        OSSClient ossClient = this.getClient();
        ossClient.putObject(this.bucketName, directoryName + "/", (InputStream)in, objectMeta);
    }

    @Override
    public OSSResultInfo createDirectory(String directoryName, ObjectMetadata meta) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(0L);
        byte[] buffer = new byte[]{};
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        OSSClient ossClient = this.getClient();
        PutObjectResult result = ossClient.putObject(this.bucketName, directoryName + "/", (InputStream)in, objectMeta);
        OSSResultInfo resultInfo = new OSSResultInfo();
        resultInfo.setBucketName(this.bucketName);
        resultInfo.setName(directoryName);
        resultInfo.setTag(result.getETag());
        resultInfo.setUrl(this.formatUrl(this.PROTOCOL_STRING + this.bucketName + "." + Constants.OSS_SERVERADDRESSS + "/" + directoryName + "/"));
        return resultInfo;
    }

    @Override
    public boolean deleteDirectory(String directoryName) {
        OSSClient ossClient = this.getClient();
        try {
            if (directoryName.lastIndexOf("/") != directoryName.length() - 1) {
                ossClient.deleteObject(this.bucketName, directoryName + "/");
            } else {
                ossClient.deleteObject(this.bucketName, directoryName);
            }
            return true;
        }
        catch (OSSException e) {
            if (e.getErrorCode().equals("NoSuchKey")) {
                return true;
            }
            throw new OSSException("", (Throwable)e);
        }
    }

    @Override
    public boolean deleteFile(String fileName) {
        OSSClient ossClient = this.getClient();
        try {
            ossClient.deleteObject(this.bucketName, fileName);
            return true;
        }
        catch (OSSException e) {
            if (e.getErrorCode().equals("NoSuchKey")) {
                return true;
            }
            throw new OSSException("", (Throwable)e);
        }
    }

    @Override
    public boolean isExitsDirectory(String directoryName) {
        OSSClient ossClient = this.getClient();
        boolean result = directoryName.lastIndexOf("/") != directoryName.length() - 1 ? ossClient.doesObjectExist(this.bucketName, directoryName + "/") : ossClient.doesObjectExist(this.bucketName, directoryName);
        return result;
    }

    @Override
    public boolean isExitsFile(String file) {
        return this.getClient().doesObjectExist(this.bucketName, file);
    }

    @Override
    public void put(String url, InputStream input) {
        this.putObject(url, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putObject(String url, InputStream input) {
        OSSClient ossClient = this.getClient();
        try {
            url = url.indexOf("/") == 0 ? url.substring(1) : url;
            boolean condition = url.contains("https://") || url.contains("http://");
            String tmpServer = !condition ? null : url.replace("https://", "").replace("http://", "").replace("//", "/").split("/")[0];
            String key = url.replace(this.server, "").replace("//", "/");
            if (tmpServer == null || this.server.contains(tmpServer)) {
                ObjectMetadata objMeta = OSSUtil.getObjectMetadata(key);
                PutObjectRequest obj = new PutObjectRequest(this.bucketName, key, input, objMeta);
                logger.debug("\u6267\u884c\u6587\u4ef6OSS\u6587\u4ef6\u4e0a\u4f20");
                ossClient.putObject(obj);
                logger.debug("\u6267\u884c\u6587\u4ef6OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug("exception:\u4f20\u5165\u7684URL\u5730\u5740\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u5730\u5740\u6216bucketName\u4e0d\u4e00\u81f4");
        }
        finally {
            ossClient.shutdown();
        }
    }

    @Override
    public File get(String url, String saveFileName) {
        String key = url.replace(this.server, "").replace("//", "/");
        File file = new File(saveFileName);
        OSSClient ossClient = this.getClient();
        ossClient.getObject(new GetObjectRequest(this.bucketName, key), file);
        return file;
    }

    @Override
    public OSSResultObject get(String url) {
        url = url.indexOf("/") == 0 ? url.substring(1) : url;
        boolean condition = url.contains("https://") || url.contains("http://");
        String tmpServer = !condition ? null : url.replace("https://", "").replace("http://", "").replace("//", "/").split("/")[0];
        String key = url.replace(this.server, "").replace("//", "/");
        if (tmpServer == null || this.server.contains(tmpServer)) {
            OSSObject obj = this.getClient().getObject(this.bucketName, key);
            OSSResultObject subobj = new OSSResultObject();
            subobj.setBucketName(obj.getBucketName());
            subobj.setKey(key);
            subobj.setFileType(OSSUtil.getFileType(url));
            subobj.setName(OSSUtil.getName(url));
            subobj.setObjectContent(obj.getObjectContent());
            subobj.setMetadata(obj.getObjectMetadata());
            subobj.setUrl(this.formatUrl(this.server + key));
            subobj.setServerAddress(Constants.OSS_SERVERADDRESSS);
            subobj.setHttpUrl(subobj.getUrl().replace("https://", "http://"));
            return subobj;
        }
        throw new OSSException("\u4f20\u5165\u7684URL\u5730\u5740\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u5730\u5740\u6216bucketName\u4e0d\u4e00\u81f4:" + tmpServer);
    }

    @Override
    public ObjectMetadata getFileMetadata(String url) {
        OSSClient ossClient = this.getClient();
        url = url.indexOf("/") == 0 ? url.substring(1) : url;
        boolean condition = url.contains("https://") || url.contains("http://");
        String tmpServer = !condition ? null : url.replace("https://", "").replace("http://", "").replace("//", "/").split("/")[0];
        String key = url.replace(this.server, "").replace("//", "/");
        if (tmpServer == null || this.server.contains(tmpServer)) {
            ObjectMetadata objMeta = ossClient.getObjectMetadata(this.bucketName, key);
            return objMeta;
        }
        throw new OSSException("\u4f20\u5165\u7684URL\u5730\u5740\u4e0e\u5f53\u524d\u670d\u52a1\u5668\u5730\u5740\u6216bucketName\u4e0d\u4e00\u81f4:" + tmpServer);
    }

    @Override
    public String getBucketUrl() {
        return this.bucketName + "." + Constants.OSS_SERVERADDRESSS;
    }

    @Override
    public void copy(String srcPath, String desPath) {
        this.getClient().copyObject(this.bucketName, this.getKey(srcPath), this.bucketName, this.getKey(desPath));
    }

    @Override
    public void copy(String srcPath, String desPath, ObjectMetadata newMeta) {
        OSSClient ossClient = this.getClient();
        CopyObjectRequest obj = new CopyObjectRequest(this.bucketName, this.getKey(srcPath), this.bucketName, this.getKey(desPath));
        obj.setNewObjectMetadata(newMeta);
        ossClient.copyObject(obj);
    }

    @Override
    public void upMeta(String url, ObjectMetadata meta) {
        this.copy(url, url, meta);
    }

    private String formatUrl(String url) {
        return this.PROTOCOL_STRING + url.replace(this.PROTOCOL_STRING, "").replace("http://", "").replace("//", "/");
    }

    private String getKey(String url) {
        url = url.indexOf("/") == 0 ? url.substring(1) : url;
        String key = url.replace(this.server, "").replace("//", "/");
        return key;
    }
}

