/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MediaMessageContent;

public class FileMessageContent
extends MediaMessageContent {
    private String name;
    private int size;
    private static final String FILE_NAME_PREFIX = "[\u6587\u4ef6] ";

    @Override
    public int getContentType() {
        return 5;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setSearchableContent(this.name);
        payload.setContent(this.size + "");
        return payload;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        this.name = payload.getSearchableContent().startsWith(FILE_NAME_PREFIX) ? payload.getSearchableContent().substring(payload.getSearchableContent().indexOf(FILE_NAME_PREFIX) + FILE_NAME_PREFIX.length()) : payload.getSearchableContent();
        this.size = Integer.parseInt(payload.getContent());
    }

    @Override
    protected int getMediaType() {
        return 4;
    }
}

