import Vue from "vue";
import VueRouter from "vue-router";

Vue.use(VueRouter);

export const constantRouterMap = [
  {
    path: "/",
    name: "Home",
    component: () => import(/* webpackChunkName: "about" */ "../views/Layout.vue"),
    redirect: "/myStationList",
    children: [
      {
        path: "/myStationList",
        name: "myStationList",
        component: () => import(/* webpackChunkName: "about" */ "../views/MyStationList.vue"),
        meta: {
          title: "我管理的",
          // keepAlive: true,
        },
      },
      {
        path: "/stationInfo",
        name: "stationInfo",
        component: () => import(/* webpackChunkName: "about" */ "../views/StationInfo.vue"),
        meta: {
          title: "驻勤点详情",
        },
      },
      {
        path: "/tempStationInfo",
        name: "tempStationInfo",
        component: () => import(/* webpackChunkName: "about" */ "../views/StationInfo.vue"),
        meta: {
          title: "岗点详情",
        },
      },
      {
        path: "/companyInfo",
        name: "companyInfo",
        component: () => import(/* webpackChunkName: "about" */ "../views/CompanyInfo.vue"),
        meta: {
          title: "公司详情",
        },
      },
      {
        path: "/stationEmployees",
        name: "stationEmployees",
        component: () => import(/* webpackChunkName: "about" */ "../views/StationEmployees.vue"),
        meta: {
          title: "人员列表",
        },
      },
      {
        path: "/multiStationEmployees",
        name: "multiStationEmployees",
        component: () => import(/* webpackChunkName: "about" */ "../views/StationEmployees.vue"),
        meta: {
          title: "跨执勤点人员",
        },
      },
      {
        path: "/tempStationEmployees",
        name: "tempStationEmployees",
        component: () => import(/* webpackChunkName: "about" */ "../views/StationEmployees.vue"),
        meta: {
          title: "执勤点人员",
        },
      },
      {
        path: "/employeeInfo",
        name: "employeeInfo",
        component: () => import(/* webpackChunkName: "about" */ "../views/EmployeeInfo.vue"),
        meta: {
          title: "人员详情",
        },
      },
      {
        path: "/aroundDispatch",
        name: "aroundDispatch",
        component: () => import(/* webpackChunkName: "about" */ "../views/AroundDispatch.vue"),
        meta: {
          title: "周边调度",
        },
      },
      {
        path: "/projectList",
        name: "projectList",
        component: () => import(/* webpackChunkName: "about" */ "../views/ProjectList.vue"),
        meta: {
          title: "项目列表",
        },
      },
    ],
  },
  {
    path: "*", //匹配未定义的路由
    redirect: "/myStationList", //重定向
  },
];

const originalPush = VueRouter.prototype.push;
VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch((err) => err);
};

const router = new VueRouter({
  mode: "hash",
  base: process.env.BASE_URL,
  routes: constantRouterMap,
});

export default router;
