import { getConfig } from "@/utils";
import axios from "axios";
import { getCurrentSetting, getCurrentUser } from "@/api/tenant-user-controller";
import TIM from "tim-js-sdk/tim-js-friendship";
import tim from "@/tim";
import { getTencentSig, getTencentTRTCSig } from "@/api/bcxin/identify";
import store from "@/store";
import router from "@/router";

export const getAccessToken = () => {
  localStorage.removeItem("accessToken")
  localStorage.removeItem("dispatchToken2")
  return new Promise((resolve) => {
    const searchParams = new URLSearchParams("?" + window.location.href.split("?")[1]); //将参数放在URLSearchParams函数中
    const accessToken = searchParams.get("accessToken");
    if (accessToken) {
      localStorage.setItem("accessToken", accessToken.toString());
      console.log('getAccessToken11111', accessToken)
      resolve(accessToken);
    } else if (localStorage.getItem("teemlink_token")) {
      localStorage.setItem("accessToken", localStorage.getItem("teemlink_token"));
      console.log('getAccessToken22222', localStorage.getItem("teemlink_token"))
      resolve(localStorage.getItem("teemlink_token"));
    } else {
      getConfig().then(({ accessToken }) => {
        const { value } = accessToken.find((x) => x.orgInstitutional === "0201");
        console.log('getAccessToken33333', value)
        localStorage.setItem("accessToken", value);
        resolve(value);
      });
    }
  });
};

export const permission = async () => {
  const accessToken = await getAccessToken();
  console.log("accessToken", accessToken);
  /**
   * @自动登录获取dispatchToken
   */
  return new Promise((resolve, reject) => {
    axios
      .post(
        `${process.env.VUE_APP_API_ROOT}/identity/AppDesk/auto-login`,
        {},
        {
          headers: {
            "Content-Type": "multipart/form-data",
            // "skip-ip-validation":1,
            accessToken,
          },
        }
      )
      .then(async (res) => {
        const { status, data } = res;
        if (status === 200) {
          const {
            data: { dispatchToken },
          } = data;
           console.log("dispatchToken2", dispatchToken);
          localStorage.setItem("dispatchToken2", dispatchToken);
          // 获取配置
          const setting = await getCurrentSetting();
          store.commit("SET_APP_SETTING", setting);
          resolve(true);
        } else if (status === 401 || status === 403) {
          localStorage.setItem("dispatchToken2", "");
          localStorage.setItem("userInfo", "");
          store.commit("showMessage", {
            type: "error",
            message: "未授权无效调度台用户",
            duration: 0,
          });
          store.commit("SET_SYS_USER_INFO", null);
          reject("未授权无效调度台用户");
        }
      })
      .catch((error) => {
        console.error(error);
        localStorage.setItem("dispatchToken2", "");
        localStorage.setItem("userInfo", "");
        store.commit("showMessage", {
          type: "error",
          message: error.response.data.message,
          duration: 0,
        });
        store.commit("SET_SYS_USER_INFO", null);
        reject("未授权无效调度台用户");
        throw error;
      });
  });
};

const getUserInfo = async () => {
  return new Promise((resolve, reject) => {
    getCurrentUser()
      .then((res) => {
        console.log(res);
        localStorage.setItem("userInfo", JSON.stringify(res));
        store.commit("SET_SYS_USER_INFO", res);
        localStorage.setItem("isSaiyan", ["Company"].includes(res.role) && res.orgInstitutional === "0201");
        return resolve(res);
      })
      .catch((error) => {
        localStorage.setItem("userInfo", "");
        store.commit("SET_SYS_USER_INFO", null);
        return reject(error);
      });
  });
};

/**
 * @根据用户信息获取腾讯SigId
 * @根据SigId和UserId登录TIM
 */
export async function loginIM(response) {
  const TRTC_SIG = await getTencentTRTCSig({
    name: response.name,
    cid: response.tencentUserId,
  });
  console.log("TRTC_SIG===", TRTC_SIG);
  const userID = response.tencentUserId;
  const { data, msg } = await getTencentSig({
    name: response.name,
    mobilePhone: response.tencentUserId,
  });
  if (!data) {
    return Promise.reject(msg);
  }
  const userSig = data;
  console.log("userSig===", userSig);
  let promise = tim.login({ userID, userSig });
  promise
    .then(function (imResponse) {
      console.log(imResponse.data); // IM登录成功
      store.commit("toggleIsLogin", true);
      store.commit("startComputeCurrent");
      store.commit({
        type: "GET_USER_INFO",
        userID,
        userSig,
        sdkAppID: Number(process.env.VUE_APP_SDK_IM_ID),
      });
      // 登录成功后会触发 SDK_READY 事件，该事件触发后，可正常使用 SDK 接口
      tim.on(TIM.EVENT.SDK_READY, ({ name }) => onReadyStateUpdate({ name }));
      // SDK NOT READY
      tim.on(TIM.EVENT.SDK_NOT_READY, ({ name }) => onReadyStateUpdate({ name }));
      // 被踢出
      tim.on(TIM.EVENT.KICKED_OUT, onKickOut);
      // SDK内部出错
      tim.on(TIM.EVENT.ERROR, onError);
      // 收到新消息
      tim.on(TIM.EVENT.MESSAGE_RECEIVED, onReceiveMessage);
      // 会话列表更新
      tim.on(TIM.EVENT.CONVERSATION_LIST_UPDATED, onUpdateConversationList);
      // 群组列表更新
      tim.on(TIM.EVENT.GROUP_LIST_UPDATED, onUpdateGroupList);
      // 会话未读总数更新，event.data 是当前单聊和群聊会话的未读总数
      tim.on(TIM.EVENT.TOTAL_UNREAD_MESSAGE_COUNT_UPDATED, onTotalUnreadMessageCountUpdated);
      if (imResponse.data.repeatLogin === true) {
        // 标识帐号已登录，本次登录操作为重复登录。v2.5.1 起支持
        console.log(imResponse.data.errorInfo);
      }
      return Promise.resolve();
    })
    .catch(function (imError) {
      console.warn("login error:", imError); // 登录失败的相关信息
      store.commit("showMessage", {
        type: "error",
        message: `IM登录失败 ${imError}`,
      });
      return Promise.reject(imError);
    });
}

export async function onReadyStateUpdate({ name }) {
  console.log(name);
  const isSDKReady = name === TIM.EVENT.SDK_READY;
  store.commit("toggleIsSDKReady", isSDKReady);
  if (isSDKReady) {
    tim
      .getMyProfile()
      .then(({ data }) => {
        store.commit("updateCurrentUserProfile", data);
      })
      .catch((error) => {
        console.log(error);
        store.commit("showMessage", {
          type: "error",
          message: `IM状态更新失败  ${error.message}`,
        });
      });
    // 登录trtc calling
    // trtcCalling.login({
    //   sdkAppID: Number(process.env.VUE_APP_SDK_IM_ID),
    //   userID,
    //   userSig,
    // });
  }
}

export function onKickOut(event) {
  store.commit("showMessage", {
    message: `${this.kickedOutReason(event.data.type)}被踢出，请重新登录。`,
    type: "error",
  });
  store.commit("toggleIsLogin", false);
  store.commit("reset");
}

export function kickedOutReason(type) {
  switch (type) {
    case this.TIM.TYPES.KICKED_OUT_MULT_ACCOUNT:
      return "由于多实例登录";
    case this.TIM.TYPES.KICKED_OUT_MULT_DEVICE:
      return "由于多设备登录";
    case this.TIM.TYPES.KICKED_OUT_USERSIG_EXPIRED:
      return "由于 userSig 过期";
    default:
      return "";
  }
}

export function onError({ data }) {
  if (data.message !== "Network Error") {
    store.commit("showMessage", {
      message: data.message,
      type: "error",
    });
  }
}

export function onReceiveMessage({ data: messageList }) {
  // this.playNotifyAudio();
  // this.handleAutoReply(messageList);
  // this.handleVideoMessage(messageList);
  // this.handleQuitGroupTip(messageList);
  console.log("pushCurrentMessageList", messageList);
  store.commit("pushCurrentMessageList", messageList);
}

export function onUpdateConversationList(event) {
  console.log("onUpdateConversationList", event);
  const { data: converstationList } = event;
  const sortList = converstationList.filter((converstation) => {
    return converstation.lastMessage.lastTime > 0;
  });
  console.log("onUpdateConversationList", sortList);
  store.commit("updateConversationList", sortList);
}

export function onUpdateGroupList(event) {
  store.commit("updateGroupList", event.data);
}

export function onTotalUnreadMessageCountUpdated(event) {
  console.log(event.data); // 当前单聊和群聊会话的未读总数
  store.commit("updateTotalUnreadMessageCount", event.data);
}

router.beforeEach(async (to, from, next) => {
  // 获取token
  // const hasToken = await getAccessToken();
  if ((to.path === "/myStationList" || to.path === "/projectList") && !localStorage.getItem("dispatchToken2")) {
    await permission();
    // 有token
    console.log(store.getters.sysUserInfo);
    if (store.getters.sysUserInfo === null) {
      // 判断当前用户是否已拉取完user_info信息
      try {
        const userInfo = await getUserInfo();
        console.log("userInfo", userInfo);
        store.commit("SET_APP_LOADING", false);
        next({ ...to, replace: true });
        // 权限通过后自动登录IM
        await loginIM(userInfo);
      } catch (err) {
        console.log(err);
        store.commit("showMessage", {
          type: "error",
          message: err,
          duration: 0,
        });
      }
    } else {
      // 有用户信息直接进入
      next();
      store.commit("SET_APP_LOADING", false);
    }
  } else {
    if (localStorage.getItem("dispatchToken2")) {
      console.log("sysUserInfo===");
      console.log(store.getters.sysUserInfo);
      if (store.getters.sysUserInfo === null) {
        // 判断当前用户是否已拉取完user_info信息
        try {
          const userInfo = await getUserInfo();
          console.log("userInfo", userInfo);
          store.commit("SET_APP_LOADING", false);
          next({ ...to, replace: true });
          // 权限通过后自动登录IM
          await loginIM(userInfo);
        } catch (err) {
          console.log(err);
          store.commit("showMessage", {
            type: "error",
            message: err,
            duration: 0,
          });
        }
      } else {
        // 有用户信息直接进入
        next();
        store.commit("SET_APP_LOADING", false);
      }
    } else {
      next("/myStationList");
    }
  }
});
