//隐藏敏感信息数据
import request from "@/api/request";
import axios from "axios";
// import axios from "axios";

export const hideNumber = (value) => {
  if (value) {
    value = value + "";
    let reg = /^(\d{2})(\d*)(\d{2})$/;
    let str = value.replace(reg, (a, b, c, d) => {
      return b + c.replace(/\d/g, "*") + d;
    });
    console.log(str);
    return str;
  } else {
    return value;
  }
};

//文字超出部分用省略号显示
export const textSlice = (value) => {
  if (value) {
    if (value.length > 10) {
      //最长固定显示10个字符
      return value.slice(0, 10) + "...";
    }
    return value;
  }
};

//视觉配置保存
// 参数{
//   "logo": "string",  文件名称
//   "title": "string"  标题
// }
export function visualSave(params) {
  return request({
    url: "/tenant/users/current/info",
    method: "PUT",
    data: params,
  });
}

// 图片文件上传
export function uploadFileApi(formData) {
  const url =
    process.env.NODE_ENV === "production"
      ? "https://v5qy.baibaodun.cn/v3/shared/common/resources"
      : "https://v5qy.te.baibaodun.com.cn/v3/shared/common/resources";
  return axios({
    url,
    method: "post",
    data: formData,
  });
}

// 获取图片配置信息
export function getVisualSetting() {
  return request({
    url: "/tenant/users/current/setting",
    method: "GET",
  });
}
