/**
 * @百川信服务入口
 * @公共服务api
 */

import axios from "axios";

// 创建axios实例
const instance = axios.create({
  // axios中请求配置有baseURL选项，表示请求URL公共部分
  baseURL: process.env.VUE_APP_BCX_API_URL,
  timeout: 30000,
});

instance.interceptors.response.use((response) => {
  const { status, data } = response;
  if (status === 200) {
    return data.data;
  }
});

export default instance;
