腾讯云即时通信 IM 本地审核插件。

### 下载

Web 项目
```javascript
npm install tim-js-sdk --save
npm install tim-profanity-filter-plugin --save
```

小程序项目
```javascript
npm install tim-wx-sdk --save
npm install tim-profanity-filter-plugin --save
```

### 集成

```javascript
import TIM from 'tim-js-sdk';
import TIMProfanityFilterPlugin from 'tim-profanity-filter-plugin';

let options = {
  SDKAppID: 0 // 接入时需要将 0 替换为您的云通信应用的 SDKAppID，类型为 Number
};
// 创建 SDK 实例，`TIM.create()`方法对于同一个 `SDKAppID` 只会返回同一份实例
let tim = TIM.create(options); // SDK 实例通常用 tim 表示

// 设置 SDK 日志输出级别，详细分级请参见 setLogLevel 接口的说明
tim.setLogLevel(0); // 普通级别，日志量较多，接入时建议使用
// tim.setLogLevel(1); // release级别，SDK 输出关键信息，生产环境时建议使用

// 注册腾讯云即时通信 IM 本地审核插件
tim.registerPlugin({'tim-profanity-filter-plugin': TIMProfanityFilterPlugin});
```

#### 相关资源
- [快速入门（Web&H5）](https://cloud.tencent.com/document/product/269/68433)
- [快速入门（小程序）](https://cloud.tencent.com/document/product/269/68433)
- [SDK 更新日志](https://cloud.tencent.com/document/product/269/38492)
- [SDK 接口文档](https://web.sdk.qcloud.com/im/doc/zh-cn/SDK.html)
- [常见问题](https://web.sdk.qcloud.com/im/doc/zh-cn/tutorial-01-faq.html)