/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.startup;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Native;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.EduService;
import com.bcxin.ars.service.GuardStatusService;
import com.bcxin.ars.service.ModuleService;
import com.bcxin.ars.service.NationService;
import com.bcxin.ars.service.NativeService;
import com.bcxin.ars.service.SecurityProfessionLevelService;
import com.bcxin.ars.service.SecurityScopeService;
import com.bcxin.ars.service.StarLevelService;
import com.bcxin.ars.service.task.TaskCatalogService;
import com.bcxin.ars.service.task.TaskLevelService;
import com.bcxin.ars.service.task.TaskStatusService;
import com.bcxin.ars.service.task.TaskTypeService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.ThirdPartyURL;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class InitService {
    private static Logger logger = LoggerFactory.getLogger(InitService.class);
    public static ServletContext context;
    public static ApplicationContext appContext;
    @Autowired
    private ConfigService configService;
    @Autowired
    private GuardStatusService guardStatusService;
    @Autowired
    private EduService eduService;
    @Autowired
    private SecurityProfessionLevelService proLevelService;
    @Autowired
    private StarLevelService starLevelService;
    @Autowired
    private SecurityScopeService scopeService;
    @Autowired
    private NationService nationService;
    @Autowired
    private NativeService nativeService;
    @Autowired
    private TaskTypeService taskTypeService;
    @Autowired
    private TaskCatalogService taskCatalogService;
    @Autowired
    private TaskLevelService taskLevelService;
    @Autowired
    private TaskStatusService taskStatusService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ConfigDao configDao;
    @Value(value="${upload-folder}")
    private String uploadFolder;
    @Value(value="${temp-folder}")
    private String tempFolder;

    public void init() {
        logger.info("init upload folder...");
        File uploadF = new File(this.uploadFolder);
        if (!uploadF.exists()) {
            uploadF.mkdirs();
        }
        logger.info("init temp folder...");
        File tempF = new File(this.tempFolder);
        if (!tempF.exists()) {
            tempF.mkdirs();
        }
        logger.info("init constants...");
        List configList = this.configService.findAll();
        for (Config config : configList) {
            context.setAttribute(config.getKey(), (Object)config.getValue());
            if (config.getKey().equals("current_native")) {
                logger.info("init current native...");
                context.setAttribute("current_native", (Object)config.getValue());
                continue;
            }
            if (config.getKey().equals("blood")) {
                logger.info("init blood list...");
                String[] bloodList = config.getValue().split("&&");
                context.setAttribute("blood", (Object)bloodList);
                continue;
            }
            if (config.getKey().equals("driving_level")) {
                logger.info("init driving level...");
                String[] drivingList = config.getValue().split("&&");
                context.setAttribute("driving_level", (Object)drivingList);
                continue;
            }
            if (config.getKey().equals("gender")) {
                logger.info("init gender...");
                String[] gender = config.getValue().split("&&");
                context.setAttribute("gender", (Object)gender);
                continue;
            }
            if (config.getKey().equals("task_alert_min")) {
                logger.info("init task_alert_min...");
                Constants.TASK_ALERT_MIN = Integer.valueOf(config.getValue().trim());
                continue;
            }
            if (!config.getKey().equals("current_province")) continue;
            Constants.APPROVAL_KEY = config.getValue() + "00";
        }
        logger.info("init edu list...");
        List guardStatusList = this.guardStatusService.findAll();
        context.setAttribute("GUARDSTATUS_LIST", (Object)guardStatusList);
        Map guardStatusMap = this.guardStatusService.findMap();
        context.setAttribute("GUARDSTATUS_MAP", (Object)guardStatusMap);
        logger.info("init edu list...");
        List eduList = this.eduService.findAll();
        context.setAttribute("EDU_LIST", (Object)eduList);
        Map eduMap = this.eduService.findMap();
        context.setAttribute("EDU_MAP", (Object)eduMap);
        logger.info("init profession level...");
        List proLevelList = this.proLevelService.findAll();
        context.setAttribute("PROFESSION_LEVEL_LIST", (Object)proLevelList);
        Map proLevelMap = this.proLevelService.findMap();
        context.setAttribute("PROFESSION_LEVEL_MAP", (Object)proLevelMap);
        logger.info("init star level...");
        List starLevelList = this.starLevelService.findAll();
        context.setAttribute("STAR_LEVEL_LIST", (Object)starLevelList);
        Map starLevelMap = this.starLevelService.findMap();
        context.setAttribute("STAR_LEVEL_MAP", (Object)starLevelMap);
        logger.info("init security scope list...");
        List scopeList = this.scopeService.findAll();
        context.setAttribute("SCOPE_LIST", (Object)scopeList);
        logger.info("init nation list...");
        List nationList = this.nationService.findAll();
        context.setAttribute("NATION_LIST", (Object)nationList);
        logger.info("init native map...");
        Map nativeMap = this.nativeService.findMap();
        context.setAttribute("NATIVE_MAP", (Object)nativeMap);
        List nativeList = this.nativeService.findAll();
        HashMap<Long, Native> nativeData = new HashMap<Long, Native>();
        for (Native nat : nativeList) {
            nativeData.put(nat.getCode(), nat);
        }
        context.setAttribute("NATIVE_DATA", nativeData);
        logger.info("init task type list...");
        List taskTypeList = this.taskTypeService.findAll();
        context.setAttribute("TASK_TYPE", (Object)taskTypeList);
        logger.info("init task status list...");
        List taskStatusList = this.taskStatusService.findAll();
        context.setAttribute("TASK_STATUS", (Object)taskStatusList);
        logger.info("init task catalog list...");
        List taskCatalogList = this.taskCatalogService.find();
        context.setAttribute("TASK_CATALOG", (Object)taskCatalogList);
        logger.info("init task level list...");
        List taskLevelList = this.taskLevelService.findAll();
        context.setAttribute("TASK_LEVEL", (Object)taskLevelList);
        logger.info("init module map...");
        Map modulelMap = this.moduleService.findAll();
        context.setAttribute("MODULE_MAP", (Object)modulelMap);
        logger.info("init config...");
        Config coninsConfig = this.configDao.findByKey("conins");
        String coninsURL = "";
        if (coninsConfig != null && coninsConfig.getValue() != null) {
            ThirdPartyURL.BAILIANBAO = coninsURL = coninsConfig.getValue();
        }
        Config fenxiaoConfig = this.configDao.findByKey("fenxiao");
        String fenxiaoURL = "";
        if (fenxiaoConfig != null && fenxiaoConfig.getValue() != null) {
            ThirdPartyURL.FENXIAO = fenxiaoURL = fenxiaoConfig.getValue();
        }
        Config authConfig = this.configDao.findByKey("auth_url");
        String authURL = "";
        if (authConfig != null && authConfig.getValue() != null) {
            ThirdPartyURL.AUTH_URL = authURL = authConfig.getValue();
        }
    }

    static {
        JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.DisableCircularReferenceDetect.getMask();
    }
}

