package com.bcxin.ars.startup;

import com.bcxin.ars.service.util.ConfigUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;

import javax.servlet.ServletContext;

@Service("startup")
public class Startup implements InitializingBean, DisposableBean, ServletContextAware, ApplicationContextAware {
	
	@Autowired
	private InitService initService;

	@Autowired
	private ConfigUtils configUtils;

	@Override
	public void setApplicationContext(ApplicationContext appContext) throws BeansException {
		InitService.appContext = appContext;
	}

	@Override
	public void setServletContext(ServletContext context) {
		InitService.context = context;
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		initService.init();
		//项目启动 初始化全部配置到缓存
		configUtils.initConfig();
	}
	
	@Override
	public void destroy() throws Exception {
		
	}

}
