/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.zw.impl;

import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.ClientUtil;
import com.bcxin.zw.dao.BazwDao;
import com.bcxin.zw.dao.PctinfoDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PctinfoServiceImpl
implements PctinfoService {
    private static Logger logger = LoggerFactory.getLogger(PctinfoServiceImpl.class);
    @Autowired
    private PctinfoDao pctinfoDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private BazwDao bazwDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalUtil approvalUtil;

    public Pctinfo findByIdnumber(String idnumber) {
        Pctinfo result = null;
        Config config = this.configUtils.getConfigByKey("current_native");
        if (config != null && config.getValue().equals("11")) {
            List list = this.pctinfoDao.findByIdnumber(idnumber);
            if (list != null && list.size() > 0) {
                result = (Pctinfo)list.get(0);
            }
        } else if (config != null && config.getValue().equals("61")) {
            List list = this.pctinfoDao.findByIdnumber(idnumber);
            if (list != null && list.size() > 0) {
                result = (Pctinfo)list.get(0);
            }
        } else if (config != null && config.getValue().equals("45")) {
            List list = this.bazwDao.findByIdnumber(idnumber);
            if (list != null && list.size() > 0) {
                result = (Pctinfo)list.get(0);
            } else {
                String zw;
                Personcertificate personcertificate = new Personcertificate();
                personcertificate.setPoliceCode("450000030000");
                personcertificate.setPoliceName("\u5e7f\u897f\u516c\u5b89\u5385\u6cbb\u5b89\u8b66\u5bdf\u603b\u961f");
                personcertificate.setCardnumber(idnumber);
                Config onlineZwSerchConfig = this.configUtils.getConfigByKey("ONLINE_ZW_SEARCH");
                if (onlineZwSerchConfig != null && "1".equals(onlineZwSerchConfig.getValue()) && StringUtil.isNotEmpty((String)(zw = this.clientUtil.queryZWForIdNumber(personcertificate)))) {
                    result = new Pctinfo();
                    result.setBarcode(zw);
                    result.setIdnumber(idnumber);
                }
            }
        }
        return result;
    }

    public List<Pctinfo> findByCardNumberList(List<String> cardNumberList) {
        Config config = this.configUtils.getConfigByKey("current_native");
        List<Object> list = new ArrayList<Pctinfo>();
        if (config != null && config.getValue().equals("61")) {
            list = this.pctinfoDao.findByCardNumberList(cardNumberList);
        } else if (config != null && config.getValue().equals("45")) {
            list = this.bazwDao.findByCardNumberList(cardNumberList);
        }
        return list;
    }

    public void autoUpdateFingerprint(Personcertificate personcertificate) {
        Pctinfo pctinfo;
        if (StringUtil.isNotEmpty((String)personcertificate.getCensorStatus()) && ("003".equals(personcertificate.getCensorStatus()) || "006".equals(personcertificate.getCensorStatus())) && (pctinfo = this.findByIdnumber(personcertificate.getCardnumber())) != null && pctinfo.getBarcode() != null && !"".equals(pctinfo.getBarcode())) {
            try {
                Config isNeedActivity = this.configUtils.getConfigByKey("IS_NEED_ACTIVITY");
                if (null == isNeedActivity || null != isNeedActivity && "1".equals(isNeedActivity.getValue())) {
                    this.approvalUtil.savePersonApproval("004", personcertificate.getId(), "activitipersoncertificateapprovalProcess");
                } else {
                    personcertificate.setApprovalstate("005");
                }
                personcertificate.setFingerprint(pctinfo.getBarcode());
                personcertificate.setFingercardState("1");
                personcertificate.setUpdateTime(new Date());
                personcertificate.setUpdateflag(Boolean.valueOf(true));
                this.personcertificateDaoAop.updateSelective(personcertificate);
                Approval approval = this.approvalDAO.findBybusinessidAndType(personcertificate.getId(), "004");
                approval.setApprovalstate(personcertificate.getApprovalstate());
                approval.setUpdateflag(Boolean.valueOf(true));
                approval.setUpdateTime(personcertificate.getUpdateTime());
                this.approvalDAO.update(approval);
            }
            catch (Exception e) {
                logger.error("\u8eab\u4efd\u8bc1\u53f7\uff1a" + personcertificate.getCardnumber() + "\u83b7\u53d6\u6307\u7eb9\u5f02\u5e38");
                if (e instanceof ArsException) {
                    Approval approval = this.approvalDAO.findBybusinessidAndType(personcertificate.getId(), "004");
                    approval.setApprovaldate(new Date());
                    approval.setUpdateflag(Boolean.valueOf(true));
                    approval.setUpdateTime(new Date());
                    approval.setApprovalstate("004");
                    approval.setApprovalreason("\u91cd\u65b0\u9009\u62e9\u529e\u4e8b\u533a\u57df\uff01");
                    approval.setApprovalperson("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6279");
                    approval.setOutreason("\u91cd\u65b0\u9009\u62e9\u529e\u4e8b\u533a\u57df\uff01");
                    this.approvalDAO.update(approval);
                    personcertificate.setApprovaldate(new Date());
                    personcertificate.setApprovalstate("004");
                    personcertificate.setApprovalreason("\u8bf7\u91cd\u65b0\u9009\u62e9\u529e\u4e8b\u533a\u57df\uff01");
                    personcertificate.setApprovalperson("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6279");
                    personcertificate.setUpdateTime(new Date());
                    approval.setUpdateflag(Boolean.valueOf(true));
                    this.personcertificateDaoAop.update(personcertificate);
                }
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public List<Personcertificate> findNofinger() {
        return this.personcertificateDao.findNofinger();
    }
}

