/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.sys.SysdictDAO;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysDictUtils")
public class SysDictUtils {
    private Logger log = LoggerFactory.getLogger(SysDictUtils.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SysdictDAO dictDao;

    public void initDictList() {
        List rList = this.dictDao.findAll();
        for (Sysdict sysdict : rList) {
            ArrayList<Sysdict> list = new ArrayList<Sysdict>();
            String dictType = sysdict.getCodeType();
            for (Sysdict sysdict2 : rList) {
                if (!dictType.equals(sysdict2.getCodeType())) continue;
                list.add(sysdict2);
            }
            this.redisUtil.set("ARS:systemDict_" + StringUtil.upperCase((String)dictType), JSON.toJSONString(list));
            this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)("systemDict_" + StringUtil.upperCase((String)dictType)));
        }
    }

    public void initDictMap(Map<String, String> map) {
        List rList = this.dictDao.findAll();
        for (Sysdict sysdict : rList) {
            map.put(sysdict.getCodeType().toUpperCase() + sysdict.getCodeValue(), sysdict.getLabel());
        }
    }

    public String getDictTypeValue(String dictType, String codeValue) {
        List<Sysdict> list = this.getDictType(dictType);
        String result = "";
        for (Sysdict s : list) {
            if (!s.getCodeValue().equals(codeValue)) continue;
            result = s.getLabel();
            break;
        }
        return result;
    }

    public List<Sysdict> getDictType(String dictType) {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:systemDict_" + StringUtil.upperCase((String)dictType));
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6systemDict\u5f02\u5e38[{}]", (Object)dictType);
        }
        if (value != null) {
            if (StringUtil.isNotEmpty((String)value)) {
                return JSON.parseArray((String)value, Sysdict.class);
            }
            Sysdict sysdict = new Sysdict();
            sysdict.setLabel("\u672a\u627e\u5230\u8be5\u7c7b\u578b\u6570\u636e");
            ArrayList<Sysdict> nullList = new ArrayList<Sysdict>();
            nullList.add(sysdict);
            return nullList;
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6systemDict\u914d\u7f6e[{}]", (Object)dictType);
        List list = this.dictDao.findByCodeType(dictType);
        if (list != null && list.size() > 0) {
            this.redisUtil.set("ARS:systemDict_" + StringUtil.upperCase((String)dictType), JSON.toJSONString((Object)list));
            this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)("systemDict_" + StringUtil.upperCase((String)dictType)));
        } else {
            this.redisUtil.set("ARS:systemDict_" + StringUtil.upperCase((String)dictType), "", 120);
        }
        return list;
    }
}

