/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.sys.SyscodeDAO;
import com.bcxin.ars.model.sys.Syscode;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysCodeUtil")
public class SysCodeUtils {
    private Logger log = LoggerFactory.getLogger(SysCodeUtils.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SyscodeDAO syscodeDAO;

    public void initDictList() {
        ArrayList codeList = new ArrayList();
        List rList = this.syscodeDAO.findAll();
        for (Syscode syscode : rList) {
            ArrayList<Syscode> list = new ArrayList<Syscode>();
            String codeType = syscode.getCodetype();
            for (Syscode syscode2 : rList) {
                if (!codeType.equals(syscode2.getCodetype())) continue;
                list.add(syscode2);
            }
            this.redisUtil.set("ARS:systemCode_" + codeType, JSON.toJSONString(list));
            this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)("systemCode_" + codeType));
        }
    }

    public String getSysCode(String type) {
        String value = "";
        ArrayList codeList = new ArrayList();
        if (StringUtil.isEmpty((String)(value = this.getSysCodeValue(type, value)))) {
            this.initDictList();
            value = this.getSysCodeValue(type, value);
        }
        if (StringUtil.isEmpty((String)value)) {
            return "\u627e\u4e0d\u5230\u8be5\u7c7b\u578b\u7684\u5b57\u5178\u6570\u636e";
        }
        return value;
    }

    private String getSysCodeValue(String type, String value) {
        try {
            value = this.redisUtil.get("ARS:systemCode_" + StringUtil.upperCase((String)type));
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"systemCode");
        }
        return value;
    }
}

