/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bcxin.ars.dao.sys.SysareaDAO;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysAreaUtil {
    private Logger log = LoggerFactory.getLogger(SysAreaUtil.class);
    public static final String REDIS_PREFIX_KEY = "ARS:";
    @Autowired
    private SysareaDAO regionDao;
    @Autowired
    private RedisUtil redisUtil;

    public Map<String, TreeView> regionMap() {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:systemRegion");
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"systemRegion");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return (Map)JSON.parseObject((String)value, (TypeReference)new TypeReference<HashMap<String, TreeView>>(){}, (Feature[])new Feature[0]);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"systemRegion");
        List rList = this.regionDao.selectAll();
        LinkedHashMap regionMap = Maps.newLinkedHashMap();
        for (TreeView region : rList) {
            regionMap.put(region.getNodeid(), region);
        }
        String configJson = JSON.toJSONString((Object)regionMap);
        this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)"systemRegion");
        this.redisUtil.set("ARS:systemRegion", configJson);
        return regionMap;
    }

    public Map<String, TreeView> regionCodeMap() {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:systemRegionCode");
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"systemRegionCode");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return (Map)JSON.parseObject((String)value, (TypeReference)new TypeReference<HashMap<String, TreeView>>(){}, (Feature[])new Feature[0]);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"systemRegionCode");
        List rList = this.regionDao.selectAll();
        LinkedHashMap regionMap = Maps.newLinkedHashMap();
        for (TreeView region : rList) {
            regionMap.put(region.getCode(), region);
        }
        String configJson = JSON.toJSONString((Object)regionMap);
        this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)"systemRegionCode");
        this.redisUtil.set("ARS:systemRegionCode", configJson);
        return regionMap;
    }

    public Collection<TreeView> provinceMap() {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:systemRegion:province");
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"systemRegion_province");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return (Collection)JSON.parseObject((String)value, (TypeReference)new TypeReference<Collection<TreeView>>(){}, (Feature[])new Feature[0]);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"systemRegion_province");
        ArrayList regions = Lists.newArrayList();
        Map<String, TreeView> regionMap = this.regionMap();
        Set<String> keySet = regionMap.keySet();
        for (String key : keySet) {
            TreeView region = regionMap.get(key);
            if (!StringUtil.isEmpty((String)region.getParentid())) continue;
            regions.add(region);
        }
        String configJson = JSON.toJSONString((Object)regions);
        this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)"systemRegion_province");
        this.redisUtil.set("ARS:systemRegion:province", configJson);
        return regions;
    }

    public Map<String, Collection<TreeView>> cityMap() {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:systemRegion:city");
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"systemRegion_city");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return (Map)JSON.parseObject((String)value, (TypeReference)new TypeReference<Map<String, Collection<TreeView>>>(){}, (Feature[])new Feature[0]);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"systemRegion_city");
        ArrayListMultimap cMap = ArrayListMultimap.create();
        Map<String, TreeView> regionMap = this.regionMap();
        Set<String> keySet = regionMap.keySet();
        for (String key : keySet) {
            TreeView region = regionMap.get(key);
            if (!Objects.equals(region.getLevel(), "2")) continue;
            cMap.put((Object)region.getParentid(), (Object)region);
        }
        String configJson = JSON.toJSONString((Object)cMap.asMap());
        this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)"systemRegion_city");
        this.redisUtil.set("ARS:systemRegion:city", configJson);
        return cMap.asMap();
    }

    public Collection<TreeView> cityMap(String parentId) {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:systemRegion:city:" + parentId);
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"systemRegion_city");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return (Collection)JSON.parseObject((String)value, (TypeReference)new TypeReference<Collection<TreeView>>(){}, (Feature[])new Feature[0]);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"systemRegion_city");
        List rList = this.regionDao.selectByParentId(Long.valueOf(Long.parseLong(parentId)));
        String configJson = JSON.toJSONString((Object)rList);
        this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)"systemRegion_city");
        this.redisUtil.set("ARS:systemRegion:city:" + parentId, configJson);
        return rList;
    }

    public Map<String, Collection<TreeView>> areaMap() {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:systemRegion:area");
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"systemRegion_area");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return (Map)JSON.parseObject((String)value, (TypeReference)new TypeReference<Map<String, Collection<TreeView>>>(){}, (Feature[])new Feature[0]);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"systemRegion_area");
        ArrayListMultimap cMap = ArrayListMultimap.create();
        Map<String, TreeView> regionMap = this.regionMap();
        Set<String> keySet = regionMap.keySet();
        for (String key : keySet) {
            TreeView region = regionMap.get(key);
            if (!Objects.equals("3", region.getLevel())) continue;
            cMap.put((Object)region.getParentid(), (Object)region);
        }
        String configJson = JSON.toJSONString((Object)cMap.asMap());
        this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)"systemRegion_area");
        this.redisUtil.set("ARS:systemRegion:area", configJson);
        return cMap.asMap();
    }

    public Collection<TreeView> areaMap(String parentId) {
        String value = "";
        try {
            value = this.redisUtil.get("ARS:systemRegion:area:" + parentId);
        }
        catch (RuntimeException ex) {
            this.log.error("redis\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"systemRegion_area");
        }
        if (StringUtil.isNotEmpty((String)value)) {
            return (Collection)JSON.parseObject((String)value, (TypeReference)new TypeReference<Collection<TreeView>>(){}, (Feature[])new Feature[0]);
        }
        this.log.debug("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e[{}]", (Object)"systemRegion_area");
        List rList = this.regionDao.selectByParentId(Long.valueOf(Long.parseLong(parentId)));
        String configJson = JSON.toJSONString((Object)rList);
        this.log.debug("\u8bbe\u7f6e\u8fdb\u5165redis\u7f13\u5b58[{}]", (Object)"systemRegion_area");
        this.redisUtil.set("ARS:systemRegion:area:" + parentId, configJson);
        return rList;
    }

    public TreeView getRegionById(String id) {
        return this.regionMap().get(id);
    }

    public TreeView getRegionByCode(String code) {
        return this.regionCodeMap().get(code);
    }
}

