/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASResultDto;
import com.bcxin.ars.dto.datasync.DataSyncDto;
import com.bcxin.ars.model.datasync.DataSyncLog;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataSyncInterfaceUtil {
    private static Logger logger = LoggerFactory.getLogger(DataSyncInterfaceUtil.class);
    @Autowired
    private InterfaceLogDao interfaceLogDao;
    @Autowired
    private DataSyncContantsUtil dataSyncContantsUtil;
    @Autowired
    private ConfigUtils configUtils;

    public AjaxResult callInterface(String url, DataSyncLog dataSyncLog) {
        DataSyncDto dataSyncDto = new DataSyncDto();
        dataSyncDto.setRegionId(this.configUtils.getCurrentProvince());
        dataSyncDto.setBusinessId(dataSyncLog.getId() + "");
        dataSyncDto.setData(JSON.toJSONString((Object)dataSyncLog));
        dataSyncDto.setTargetServiceUrl("/dataSync/receive.json");
        dataSyncDto.setCallbackUrl(this.dataSyncContantsUtil.getTimeUrl() + "/dataSync/callback.json");
        dataSyncDto.setSrcApp(this.dataSyncContantsUtil.getTimeUrl());
        dataSyncDto.setTargetApp(this.dataSyncContantsUtil.getTargetTimeUrl());
        dataSyncDto.setFileUrls(this.dataSyncContantsUtil.getTimeUrl() + dataSyncLog.getUrl());
        Map paramMap = BeanUtil.beanToMap((Object)dataSyncDto);
        String msg = "";
        Boolean result = true;
        Object data = null;
        url = this.dataSyncContantsUtil.getDataSyncFtpUrl() + url;
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(Boolean.valueOf(true));
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString((Object)paramMap));
        try {
            String resultStr = HttpUtil.post((String)url, (Map)paramMap, (int)30000);
            interfaceLog.setResult(resultStr);
            SAASResultDto resultDto = (SAASResultDto)JSONObject.parseObject((String)resultStr, SAASResultDto.class);
            if (resultDto != null && StringUtil.isNotEmpty((String)resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.BTK_IS_SUCCESS.equals(retType)) {
                    data = resultDto.getData();
                    logger.info("\u767e\u4fdd\u76fe\u8c03\u7528FTP\u540c\u6b65\u670d\u52a1\u6210\u529f");
                } else {
                    result = false;
                    msg = resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("\u767e\u4fdd\u76fe\u8c03\u7528FTP\u540c\u6b65\u670d\u52a1\u5931\u8d25");
                }
            } else {
                result = false;
                msg = "\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c";
                logger.info("\u767e\u4fdd\u76fe\u8c03\u7528FTP\u540c\u6b65\u670d\u52a1\u5931\u8d25,\u6ca1\u6709\u8fd4\u56de\u7ed3\u679c");
            }
        }
        catch (Exception e) {
            result = false;
            logger.error(e.getMessage(), (Throwable)e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result.booleanValue());
        new Thread(() -> this.interfaceLogDao.insert(interfaceLog)).start();
        if (StringUtil.isNotEmpty((String)msg)) {
            msg = "\u767e\u4fdd\u76fe\u8c03\u7528FTP\u540c\u6b65\u670d\u52a1\u5931\u8d25:" + msg;
        }
        return new AjaxResult(result.booleanValue(), msg, data);
    }

    public static void main(String[] args) {
    }
}

