/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.DatasyncDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.TaskDao;
import com.bcxin.ars.dao.task.TaskFeedbackDao;
import com.bcxin.ars.dao.task.TaskPersonDao;
import com.bcxin.ars.dao.task.TaskPersonScheduleDao;
import com.bcxin.ars.dao.task.TaskScheduleDao;
import com.bcxin.ars.dao.task.UrgentTeamPersonDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.HotMap;
import com.bcxin.ars.dto.ReportData;
import com.bcxin.ars.dto.TaskSearchDto;
import com.bcxin.ars.dto.UrgentPerson;
import com.bcxin.ars.dto.UrgentTaskDTO;
import com.bcxin.ars.dto.task.TaskDetailSearchDto;
import com.bcxin.ars.dto.task.TaskDto;
import com.bcxin.ars.dto.task.TaskFeedBackDto;
import com.bcxin.ars.dto.task.TaskPersonDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Datasync;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskCatalog;
import com.bcxin.ars.model.task.TaskFeedback;
import com.bcxin.ars.model.task.TaskLevel;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.model.task.TaskPersonSchedule;
import com.bcxin.ars.model.task.TaskPersonScheduleDetail;
import com.bcxin.ars.model.task.TaskSchedule;
import com.bcxin.ars.model.task.TaskStatus;
import com.bcxin.ars.model.task.TaskType;
import com.bcxin.ars.service.SearchHistoryService;
import com.bcxin.ars.service.SecurityCompanyScheduleService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.impl.UrgentTaskThread;
import com.bcxin.ars.service.sys.impl.ApprovalServiceImpl;
import com.bcxin.ars.service.task.AppNoticeService;
import com.bcxin.ars.service.task.TaskFeedbackService;
import com.bcxin.ars.service.task.TaskService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FirstLetterUtil;
import com.bcxin.ars.util.JPushUtil;
import com.bcxin.ars.util.MessageUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.poi.ExcelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Task.class)
public class TaskServiceImpl
implements TaskService {
    @Autowired
    private TaskDao taskDao;
    @Autowired
    private TaskScheduleDao taskScheduleDao;
    @Autowired
    private TaskPersonDao taskPersonDao;
    @Autowired
    private TaskPersonScheduleDao taskPersonScheduleDao;
    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private TaskFeedbackDao feedbackDao;
    @Autowired
    private TaskFeedbackService feedbackService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private AppNoticeService appNoticeService;
    @Autowired
    private SecurityCompanyScheduleService securityCompanyScheduleService;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SearchHistoryService searchHistoryService;
    @Autowired
    private SecurityCompanyService companyService;
    @Autowired
    private UrgentTeamPersonDAO urgentTeamPersonDAO;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private DatasyncDao datasyncDao;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;
    private Logger logger = LoggerFactory.getLogger(ApprovalServiceImpl.class);

    public Task findById(Long id) {
        Task task = this.taskDao.findById(id);
        if (task != null) {
            if (task.getStartDate() != null) {
                String[] dateStatrtTime = task.getStartDate().split(" ");
                task.setStartDate(dateStatrtTime[0]);
            }
            if (task.getEndDate() != null) {
                String[] dateEndTime = task.getEndDate().split(" ");
                task.setEndDate(dateEndTime[0]);
            }
            task.getPersonList();
            task.getScheduleList();
        }
        return task;
    }

    public Task findUrgentById(Long id) {
        Task task = this.taskDao.findUrgentById(id);
        ArrayList<TaskPerson> personList = new ArrayList<TaskPerson>();
        List list = this.taskPersonDao.findByTaskId(id);
        if (list != null && list.size() > 0) {
            for (TaskPerson t : list) {
                if (!t.getAcceptStatus().equals(1) && !t.getAcceptStatus().equals(3)) continue;
                UrgentPerson urgentPerson = this.urgentTeamPersonDAO.queryUrgentPersonByPersonId(t.getPerson().getId());
                if (urgentPerson != null) {
                    t.setInCharge(urgentPerson.isInCharge());
                }
                t.setPerson(this.personDao.findById(t.getPerson().getId()));
                personList.add(t);
            }
        }
        task.setPersonList(personList);
        return task;
    }

    public List<Task> findUrgentByPersnId(UrgentTaskDTO dto) {
        List task = this.taskDao.findUrgentByPersnId(dto);
        return task;
    }

    public TaskSearchDto search(TaskSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            this.searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_TASK, user);
        }
        if (user.getPlatform() == 2) {
            if (StringUtil.isEmpty((String)dto.getTaskTypeName()) || StringUtil.isNotEmpty((String)dto.getTaskTypeName()) && !dto.getTaskTypeName().equals("\u7d27\u6025")) {
                SecurityCompany company = this.companyDao.findByUserid(user.getId());
                dto.setCompanyId(company.getId());
            }
        } else if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        List data = this.taskDao.search(dto);
        for (Task task : data) {
            task.getScheduleList();
        }
        Long count = this.taskDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public TaskSearchDto searchForPersonManage(TaskSearchDto dto) {
        SecurityCompany company;
        User user = this.arsUtil.getCurrentUser();
        if (StringUtil.isNotEmpty((String)dto.getKeyword())) {
            this.searchHistoryService.saveOrUpdate(dto.getKeyword(), Constants.SEARCHTYPE_TASK, user);
        }
        if ((company = this.companyService.getCurrentUserCompany()) != null) {
            dto.setCompanyId(company.getId());
        } else if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        }
        List data = this.taskDao.search(dto);
        for (Task task : data) {
            task.getScheduleList();
        }
        Long count = this.taskDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public List<Task> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.taskDao.searchForDataSynchronization(dto);
    }

    public void saveOrUpdate(Task task) {
        User user = this.arsUtil.getCurrentUser();
        Task dbTask = this.taskDao.findSaasTaskById(task.getId());
        if (dbTask == null) {
            TaskStatus status = new TaskStatus();
            if (user.getPlatform().equals(1)) {
                status.setId(Long.valueOf(2L));
                Date date = new Date();
                Timestamp nousedate = new Timestamp(date.getTime());
                task.setStartDate(nousedate.toString().substring(0, 19));
                TaskCatalog taskCatalog = new TaskCatalog();
                taskCatalog.setId(Long.valueOf(6L));
                task.setTaskCatalog(taskCatalog);
                TaskLevel level = new TaskLevel();
                level.setId(Long.valueOf(4L));
                task.setTaskLevel(level);
                SecurityCompany securityCompany = new SecurityCompany();
                securityCompany.setId(Long.valueOf(1L));
                task.setCompany(securityCompany);
            } else if (user.getPlatform() == 2 || user.getPlatform() == 3) {
                status.setId(Long.valueOf(1L));
                SecurityCompany company = null;
                if (user.getPlatform() == 2) {
                    company = this.companyDao.findByUserid(user.getId());
                }
                if (company == null) {
                    throw new RuntimeException("\u5f53\u524d\u767b\u5f55ID\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u516c\u53f8\u4fe1\u606f\uff1aUserid:" + user.getId());
                }
                task.setAreacode(company.getAreaCode());
                task.setCompany(company);
            }
            task.setTaskStatus(status);
            task.setCreateTime(new Date());
            task.setNativeCode(this.arsUtil.getCurrentNatvie());
            task.setCreater(user.getId().toString());
            task.setUpdateBy(user.getRealname());
            task.setUpdateTime(task.getCreateTime());
            task.setActive(Boolean.valueOf(true));
            task.setSendcount(Integer.valueOf(0));
            if (task.getId() == null) {
                task.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            }
            this.taskDao.save(task);
            if ((user.getPlatform() == 2 || user.getPlatform() == 3) && task.getTaskType().getId() != 4L) {
                this.saveScheduleList(task);
                this.savePersonList(task);
            }
            if (user.getPlatform() == 1 && task.getTaskType().getId() == 4L) {
                SecurityCompanySchedule securityCompanySchedule = new SecurityCompanySchedule();
                securityCompanySchedule.setId(Long.valueOf(1L));
                TaskSchedule taskSchedule = new TaskSchedule();
                taskSchedule.setNativeCode(this.arsUtil.getCurrentNatvie());
                taskSchedule.setCreateTime(new Date());
                taskSchedule.setSchedule(securityCompanySchedule);
                taskSchedule.setTaskId(task.getId());
                this.taskScheduleDao.save(taskSchedule);
                new Thread(() -> {
                    try {
                        UrgentTaskThread taskThread = new UrgentTaskThread();
                        taskThread.setMinute(6000);
                        taskThread.setTaskDao(this.taskDao);
                        taskThread.setPersonDao(this.personDao);
                        taskThread.setTaskService(this);
                        taskThread.setTaskId(task.getId());
                        taskThread.run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
            }
        } else {
            dbTask.setUpdateTime(new Date());
            dbTask.setUpdateBy(user.getRealname());
            if (task.getName() != null && task.getName().trim().length() > 0) {
                dbTask.setName(task.getName());
            }
            if (task.getTaskLevel() != null && task.getTaskLevel().getId() != null && task.getTaskLevel().getId() > 0L) {
                dbTask.setTaskLevel(task.getTaskLevel());
            }
            if (task.getTaskCatalog() != null && task.getTaskCatalog().getId() != null && task.getTaskCatalog().getId() > 0L) {
                dbTask.setTaskCatalog(task.getTaskCatalog());
            }
            if (task.getTaskStatus() != null && task.getTaskStatus().getId() != null && task.getTaskStatus().getId() > 0L) {
                dbTask.setTaskStatus(task.getTaskStatus());
            }
            if (task.getAddress() != null && task.getAddress().trim().length() > 0) {
                dbTask.setAddress(task.getAddress().trim());
            }
            if (task.getArea() != null && task.getArea().trim().length() > 0) {
                dbTask.setArea(task.getArea().trim());
            }
            if (task.getLongitude() != null && task.getLongitude().trim().length() > 0) {
                dbTask.setLongitude(task.getLongitude());
            }
            if (task.getLatitude() != null && task.getLatitude().trim().length() > 0) {
                dbTask.setLatitude(task.getLatitude());
            }
            if (task.getScope() != null && task.getScope() > 0) {
                dbTask.setScope(task.getScope());
            }
            if (task.getDetail() != null && task.getDetail().length() > 0) {
                dbTask.setDetail(task.getDetail());
            }
            if (task.getSendcount() != null && task.getSendcount() > 0) {
                dbTask.setSendcount(task.getSendcount());
            }
            if (StringUtil.isNotEmpty((String)task.getStartDate())) {
                dbTask.setStartDate(task.getStartDate());
            }
            if (StringUtil.isNotEmpty((String)task.getEndDate())) {
                dbTask.setEndDate(task.getEndDate());
            }
            dbTask.setPersonList(task.getPersonList());
            dbTask.setScheduleList(task.getScheduleList());
            dbTask.setRepeat(task.isRepeat());
            dbTask.setTaskType(task.getTaskType());
            this.taskDao.update(dbTask);
            if ((user.getPlatform() == 2 || user.getPlatform() == 3) && task.getTaskType().getId() != 4L) {
                this.deletePersonList(dbTask);
                this.savePersonList(dbTask);
                this.deleteScheduleList(dbTask);
                this.saveScheduleList(dbTask);
            }
        }
    }

    public void saveOrUpdateForDS(Task task) {
        Task dbTask = this.findById(task.getId());
        if (task.getActive() == null) {
            task.setActive(Boolean.valueOf(true));
        }
        if (!task.getActive().booleanValue()) {
            this.delete(task);
        } else if (dbTask == null) {
            this.taskDao.save(task);
            if (task.getTaskType().getId() != 4L) {
                this.saveScheduleList(task);
                this.savePersonListForDS(task);
            }
        } else if (dbTask != null && task.getUpdateTime().getTime() > dbTask.getUpdateTime().getTime()) {
            this.taskDao.update(task);
            if (task.getTaskType().getId() != 4L) {
                this.deletePersonList(task);
                this.savePersonListForDS(task);
                this.deleteScheduleList(task);
                this.saveScheduleList(task);
            }
        }
    }

    public void delete(Task task) {
        this.deletePersonList(task);
        task.setUpdateTime(new Date());
        this.taskDao.delete(task);
    }

    public void deleteScheduleList(Task task) {
        this.taskScheduleDao.deleteByTask(task);
    }

    public void saveScheduleList(Task task) {
        for (SecurityCompanySchedule cs : task.getScheduleList()) {
            TaskSchedule ts = new TaskSchedule();
            ts.setCreateTime(task.getCreateTime());
            ts.setNativeCode(task.getNativeCode());
            ts.setTaskId(task.getId());
            ts.setSchedule(cs);
            this.taskScheduleDao.save(ts);
        }
    }

    public void deletePersonList(Task task) {
        List taskPersonList = this.taskPersonDao.findByTaskId(task.getId());
        for (TaskPerson tp : taskPersonList) {
            List tpsList = this.taskPersonScheduleDao.findByTaskPersonIdStatus(tp.getId(), null);
            for (TaskPersonSchedule tps : tpsList) {
                this.taskPersonScheduleDao.deleteDetailByPersonSchedule(tps);
            }
            this.taskPersonScheduleDao.deleteByTaskPersonId(tp.getId());
        }
        this.taskPersonDao.deleteByTask(task);
    }

    public void savePersonList(Task task) {
        for (TaskPerson tp : task.getPersonList()) {
            tp.setCreateTime(task.getCreateTime());
            tp.setNativeCode(task.getNativeCode());
            tp.setTaskId(task.getId());
            tp.setAcceptStatus(Integer.valueOf(1));
            this.taskPersonDao.save(tp);
            SecurityPerson person = this.personDao.findById(tp.getPerson().getId());
            for (TaskPersonSchedule tps : tp.getScheduleList()) {
                tps.setNativeCode(tp.getNativeCode());
                tps.setTaskPersonId(tp.getId());
                this.taskPersonScheduleDao.save(tps);
                for (SecurityCompanySchedule scs : tps.getScheduleDetail()) {
                    TaskPersonScheduleDetail personScheduleDetail = new TaskPersonScheduleDetail();
                    personScheduleDetail.setNativeCode(tps.getNativeCode());
                    personScheduleDetail.setPersonScheduleId(tps.getId());
                    personScheduleDetail.setScheduleId(scs.getId());
                    this.taskPersonScheduleDao.saveDetail(personScheduleDetail);
                }
            }
            this.appNoticeService.saveByTaskPerson(task, tp);
            this.updateAcceptStatus(tp);
        }
    }

    public void savePersonListForDS(Task task) {
        for (TaskPerson tp : task.getPersonList()) {
            tp.setCreateTime(task.getCreateTime());
            tp.setNativeCode(task.getNativeCode());
            tp.setTaskId(task.getId());
            tp.setAcceptStatus(Integer.valueOf(0));
            this.taskPersonDao.save(tp);
            for (TaskPersonSchedule tps : tp.getScheduleList()) {
                tps.setNativeCode(tp.getNativeCode());
                tps.setTaskPersonId(tp.getId());
                this.taskPersonScheduleDao.save(tps);
                for (SecurityCompanySchedule scs : tps.getScheduleDetail()) {
                    TaskPersonScheduleDetail personScheduleDetail = new TaskPersonScheduleDetail();
                    personScheduleDetail.setNativeCode(tps.getNativeCode());
                    personScheduleDetail.setPersonScheduleId(tps.getId());
                    personScheduleDetail.setScheduleId(scs.getId());
                    this.taskPersonScheduleDao.saveDetail(personScheduleDetail);
                }
            }
        }
    }

    public List<Task> findByPerson(SecurityPerson person) {
        Date now = new Date();
        String weekDay = DateUtil.getWeekOfDate((Date)now);
        String today = DateUtil.systemDate.format(now);
        List weekList = this.taskDao.findByPerson(person.getId(), weekDay, today, Constants.TASK_ALERT_MIN);
        List dateList = this.taskDao.findByPerson(person.getId(), today, today, Constants.TASK_ALERT_MIN);
        ArrayList<Task> data = new ArrayList<Task>();
        if (weekList.size() > 0) {
            data.addAll(weekList);
        }
        if (dateList.size() > 0) {
            data.addAll(dateList);
        }
        return data;
    }

    public List<ReportData> findAreaReport() {
        User user = this.arsUtil.getCurrentUser();
        SecurityCompany sc = this.companyService.getCurrentUserCompany();
        TaskSearchDto dto = new TaskSearchDto();
        if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        } else {
            if (sc == null) {
                return null;
            }
            dto.setCompanyId(sc.getId());
        }
        return this.taskDao.findAreaReport(dto);
    }

    public Map<String, String[]> findCatalogReport() {
        User user = this.arsUtil.getCurrentUser();
        SecurityCompany sc = this.companyService.getCurrentUserCompany();
        TaskSearchDto dto = new TaskSearchDto();
        if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        } else {
            if (sc == null) {
                return null;
            }
            dto.setCompanyId(sc.getId());
        }
        List list = this.taskDao.findCatalogReport(dto);
        HashMap<String, String[]> data = new HashMap<String, String[]>();
        String[] name = new String[list.size()];
        String[] value = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ReportData rd = (ReportData)list.get(i);
            name[i] = rd.getName();
            value[i] = rd.getValue() + "";
        }
        data.put("name", name);
        data.put("value", value);
        return data;
    }

    public List<ReportData> findLevelReport() {
        User user = this.arsUtil.getCurrentUser();
        SecurityCompany sc = this.companyService.getCurrentUserCompany();
        TaskSearchDto dto = new TaskSearchDto();
        if (user.getPlatform() == 1) {
            dto.setPath(user.getPolice().getPath());
            dto.setUserid(user.getId());
        } else {
            if (sc == null) {
                return null;
            }
            dto.setCompanyId(sc.getId());
        }
        return this.taskDao.findLevelReport(dto);
    }

    public void updateStatus() {
        this.taskDao.updateStatus();
    }

    public void updateEndStatus() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateAcceptStatus(TaskPerson taskPerson) {
        this.logger.info((taskPerson != null && taskPerson.getTaskId() != null && taskPerson.getPerson() != null) + "");
        if (taskPerson == null || taskPerson.getTaskId() == null || taskPerson.getPerson() == null) throw new ArsException("\u6570\u636e\u5f02\u5e38");
        this.logger.info((taskPerson.getPerson().getId() != null && taskPerson.getAcceptStatus() != null) + "");
        if (taskPerson.getPerson().getId() == null || taskPerson.getAcceptStatus() == null) throw new ArsException("\u6570\u636e\u5f02\u5e38");
        TaskPerson dbTaskPerson = this.taskPersonDao.findByTaskIdPersonId(taskPerson.getTaskId(), taskPerson.getPerson().getId());
        if (dbTaskPerson.getAcceptStatus().equals(4)) {
            throw new ArsException("\u4efb\u52a1\u5df2\u8fc7\u671f\uff01");
        }
        if (taskPerson.getAcceptStatus().equals(2) && dbTaskPerson.isInCharge()) {
            throw new ArsException("\u8d1f\u8d23\u4eba\u4e0d\u80fd\u62d2\u7edd\u63a5\u53d7\u4efb\u52a1\uff01");
        }
        dbTaskPerson.setAcceptStatus(taskPerson.getAcceptStatus());
        dbTaskPerson.setRejectReason(taskPerson.getRejectReason());
        dbTaskPerson.setUpdateTime(new Date());
        this.taskPersonDao.update(dbTaskPerson);
        if (!taskPerson.getAcceptStatus().equals(1)) return;
        Task task = this.taskDao.findSaasTaskById(taskPerson.getTaskId());
        if (task == null) {
            task = this.taskDao.findUrgentById(taskPerson.getTaskId());
        }
        if (task != null && task.getTaskType().getId() == 4L) {
            List list = this.taskPersonDao.findUnAcceptByPersonId(taskPerson.getPerson().getId());
            for (TaskPerson tPerson : list) {
                List tpsList = this.taskPersonScheduleDao.findByTaskPersonIdStatus(tPerson.getId(), null);
                for (TaskPersonSchedule tps : tpsList) {
                    this.taskPersonScheduleDao.deleteDetailByPersonSchedule(tps);
                }
                this.taskPersonScheduleDao.deleteByTaskPersonId(tPerson.getId());
                this.taskPersonDao.delete(tPerson);
            }
            String urgentTaskMsg = "\u7d27\u6025\u901a\u77e5\uff1a%PERSONNAME%\u88ab\u516c\u5b89\u673a\u5173\u9009\u4e2d\uff0c\u6b63\u5728\u6267\u884c\u7d27\u6025\u4efb\u52a1\u3002\u4efb\u52a1\u540d\u79f0\uff1a%TASKNAME%\uff0c\u4efb\u52a1\u5730\u5740\uff1a%ADDRESS%\u3002";
            urgentTaskMsg = urgentTaskMsg.replace("%TASKNAME%", task.getName());
            urgentTaskMsg = urgentTaskMsg.replace("%ADDRESS%", task.getAddress());
            SecurityPerson person = this.personDao.findById(taskPerson.getPerson().getId());
            MessageUtil.sendMessage((String)person.getPhone(), (String)urgentTaskMsg.replace("%PERSONNAME%", person.getRealName()), (MessageLogDao)this.messageLogDao);
            SecurityCompany company = person.getRelation().getCompany();
            List personList = this.urgentTeamPersonDAO.queryUrgentPersonByCompnyId(company.getId());
            if (personList != null) {
                for (UrgentPerson urgentPerson : personList) {
                    if (!urgentPerson.isInCharge()) continue;
                    String urgentChargeTaskMsg = "\u7d27\u6025\u901a\u77e5\uff1a%PERSONNAME%\u88ab\u516c\u5b89\u673a\u5173\u9009\u4e2d\uff0c\u6b63\u5728\u6267\u884c\u7d27\u6025\u4efb\u52a1\u3002\u4efb\u52a1\u540d\u79f0\uff1a%TASKNAME%\uff0c\u4efb\u52a1\u5730\u5740\uff1a%ADDRESS%\u3002";
                    urgentChargeTaskMsg = urgentChargeTaskMsg.replace("%TASKNAME%", task.getName());
                    urgentChargeTaskMsg = urgentChargeTaskMsg.replace("%ADDRESS%", task.getAddress());
                    MessageUtil.sendMessage((String)urgentPerson.getPhone(), (String)urgentChargeTaskMsg.replace("%PERSONNAME%", person.getRealName()), (MessageLogDao)this.messageLogDao);
                }
            }
        }
        try {
            this.createTaskFeedbackByTask(task, taskPerson.getPerson().getId());
            return;
        }
        catch (Exception exception) {}
    }

    public List<Task> findByPersonAcceptStatus(Long personId, Integer acceptStatus) {
        return this.taskDao.findByPersonAcceptStatus(personId, acceptStatus);
    }

    public void autoCreateTaskFeedback() {
        TaskSearchDto dto = new TaskSearchDto();
        dto.setIsRepeat(Integer.valueOf(1));
        dto.setTaskType(Integer.valueOf(1));
        dto.setPaging(false);
        List taskList = this.taskDao.search(dto);
        for (Task task : taskList) {
            this.autoCreateTaskFeedbackByTask(task);
        }
    }

    private void autoCreateTaskFeedbackByTask(Task task) {
        Long nativeCode = task.getNativeCode();
        if (nativeCode == null) {
            nativeCode = Long.parseLong("3502");
        }
        List personList = task.getPersonList();
        for (TaskPerson taskPerson : personList) {
            if (taskPerson.getAcceptStatus() == null || !taskPerson.getAcceptStatus().equals(1)) continue;
            List scheduleList = taskPerson.getScheduleList();
            for (TaskPersonSchedule taskPersonSchedule : scheduleList) {
                List scheduleDetails = taskPersonSchedule.getScheduleDetail();
                String taskDate = taskPersonSchedule.getTaskDate();
                if (!task.getTaskType().getId().equals(1L) || !task.isRepeat()) continue;
                List nextweeks = DateUtil.getNextWeekDates();
                for (String nextweek : nextweeks) {
                    if (!DateUtil.getWeekOfDate((String)nextweek).equals(taskDate)) continue;
                    this.feedbackDao.deleteByTaskIdPersonIdTaskDate(task.getId(), taskPerson.getPerson().getId(), nextweek);
                    for (SecurityCompanySchedule securityCompanySchedule : scheduleDetails) {
                        TaskFeedback feedback = new TaskFeedback();
                        feedback.setNativeCode(nativeCode);
                        feedback.setPerson(taskPerson.getPerson());
                        feedback.setTask(task);
                        feedback.setTaskDate(nextweek);
                        feedback.setScheduleId(securityCompanySchedule.getId());
                        feedback.setScheduleName(securityCompanySchedule.getName());
                        feedback.setTaskStart(securityCompanySchedule.getStartTime());
                        feedback.setTaskEnd(securityCompanySchedule.getEndTime());
                        TaskStatus taskStatus = new TaskStatus();
                        taskStatus.setId(Long.valueOf(1L));
                        feedback.setTaskStatus(taskStatus);
                        feedback.setCreateTime(new Date());
                        feedback.setUpdateTime(new Date());
                        feedback.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                        this.feedbackDao.save(feedback);
                    }
                }
            }
        }
    }

    private void createTaskFeedbackByTask(Task task, long personId) {
        TaskPerson taskPerson;
        Long nativeCode = this.arsUtil.getCurrentNatvie();
        String now = DateUtil.systemDate.format(new Date());
        if (nativeCode == null) {
            nativeCode = task.getNativeCode();
        }
        if ((taskPerson = this.taskPersonDao.findByTaskIdPersonId(task.getId(), Long.valueOf(personId))) != null && taskPerson.getAcceptStatus() != null && taskPerson.getAcceptStatus().equals(1)) {
            if (task.getTaskType().getId().equals(4L)) {
                TaskFeedback feedback = new TaskFeedback();
                feedback.setNativeCode(nativeCode);
                feedback.setPerson(taskPerson.getPerson());
                feedback.setTask(task);
                feedback.setTaskStart(DateUtil.convertDateToString((Date)DateUtil.convertStringToDate((String)task.getStartDate()), (String)"HH:mm:ss"));
                TaskStatus taskStatus = new TaskStatus();
                taskStatus.setId(Long.valueOf(2L));
                feedback.setTaskStatus(taskStatus);
                feedback.setScheduleId(Long.valueOf(1L));
                feedback.setTaskDate(DateUtil.getCurrentDate());
                feedback.setScheduleName("\u7d27\u6025\u4efb\u52a1");
                feedback.setStartTime(new Date());
                feedback.setCreateTime(new Date());
                feedback.setUpdateTime(new Date());
                feedback.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                this.feedbackDao.save(feedback);
                return;
            }
            List scheduleList = taskPerson.getScheduleList();
            for (TaskPersonSchedule taskPersonSchedule : scheduleList) {
                SecurityCompanySchedule securityCompanySchedule2;
                List scheduleDetails = taskPersonSchedule.getScheduleDetail();
                String taskDate = taskPersonSchedule.getTaskDate();
                if (task.getTaskType().getId().equals(2L) || task.getTaskType().getId().equals(1L) && !task.isRepeat()) {
                    try {
                        Date tDate = DateUtil.systemDate.parse(taskDate);
                        Date currentDate = DateUtil.systemDate.parse(now);
                        if (tDate.getTime() < currentDate.getTime()) {
                            continue;
                        }
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    this.feedbackDao.deleteByTaskIdPersonIdTaskDate(task.getId(), taskPerson.getPerson().getId(), taskDate);
                    for (SecurityCompanySchedule securityCompanySchedule2 : scheduleDetails) {
                        TaskFeedback feedback = new TaskFeedback();
                        feedback.setNativeCode(nativeCode);
                        feedback.setPerson(taskPerson.getPerson());
                        feedback.setTask(task);
                        feedback.setTaskDate(taskDate);
                        feedback.setScheduleId(securityCompanySchedule2.getId());
                        feedback.setScheduleName(securityCompanySchedule2.getName());
                        feedback.setTaskStart(securityCompanySchedule2.getStartTime());
                        feedback.setTaskEnd(securityCompanySchedule2.getEndTime());
                        TaskStatus taskStatus = new TaskStatus();
                        taskStatus.setId(Long.valueOf(1L));
                        feedback.setTaskStatus(taskStatus);
                        feedback.setCreateTime(new Date());
                        feedback.setUpdateTime(new Date());
                        feedback.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                        this.feedbackDao.save(feedback);
                    }
                    continue;
                }
                if (!task.getTaskType().getId().equals(1L) || !task.isRepeat()) continue;
                List thisweeks = DateUtil.getThisWeekDates();
                securityCompanySchedule2 = thisweeks.iterator();
                while (securityCompanySchedule2.hasNext()) {
                    String thisweek = (String)securityCompanySchedule2.next();
                    if (!DateUtil.getWeekOfDate((String)thisweek).equals(taskDate)) continue;
                    try {
                        Date tDate = DateUtil.systemDate.parse(thisweek);
                        Date currentDate = DateUtil.systemDate.parse(now);
                        if (tDate.getTime() < currentDate.getTime()) {
                            continue;
                        }
                    }
                    catch (ParseException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.feedbackDao.deleteByTaskIdPersonIdTaskDate(task.getId(), taskPerson.getPerson().getId(), thisweek);
                    for (SecurityCompanySchedule securityCompanySchedule3 : scheduleDetails) {
                        TaskFeedback feedback = new TaskFeedback();
                        feedback.setNativeCode(nativeCode);
                        feedback.setPerson(taskPerson.getPerson());
                        feedback.setTask(task);
                        feedback.setTaskDate(thisweek);
                        feedback.setScheduleId(securityCompanySchedule3.getId());
                        feedback.setScheduleName(securityCompanySchedule3.getName());
                        feedback.setTaskStart(securityCompanySchedule3.getStartTime());
                        feedback.setTaskEnd(securityCompanySchedule3.getEndTime());
                        TaskStatus taskStatus = new TaskStatus();
                        taskStatus.setId(Long.valueOf(1L));
                        feedback.setTaskStatus(taskStatus);
                        feedback.setCreateTime(new Date());
                        feedback.setUpdateTime(new Date());
                        feedback.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                        this.feedbackDao.save(feedback);
                    }
                }
                List nextweeks = DateUtil.getNextWeekDates();
                for (String nextweek : nextweeks) {
                    if (!DateUtil.getWeekOfDate((String)nextweek).equals(taskDate)) continue;
                    this.feedbackDao.deleteByTaskIdPersonIdTaskDate(task.getId(), taskPerson.getPerson().getId(), nextweek);
                    for (SecurityCompanySchedule securityCompanySchedule4 : scheduleDetails) {
                        TaskFeedback feedback = new TaskFeedback();
                        feedback.setNativeCode(nativeCode);
                        feedback.setPerson(taskPerson.getPerson());
                        feedback.setTask(task);
                        feedback.setTaskDate(nextweek);
                        feedback.setScheduleId(securityCompanySchedule4.getId());
                        feedback.setScheduleName(securityCompanySchedule4.getName());
                        feedback.setTaskStart(securityCompanySchedule4.getStartTime());
                        feedback.setTaskEnd(securityCompanySchedule4.getEndTime());
                        TaskStatus taskStatus = new TaskStatus();
                        taskStatus.setId(Long.valueOf(1L));
                        feedback.setTaskStatus(taskStatus);
                        feedback.setCreateTime(new Date());
                        feedback.setUpdateTime(new Date());
                        feedback.setId(Long.valueOf(this.idGeneratorUtil.createID()));
                        this.feedbackDao.save(feedback);
                    }
                }
            }
        }
    }

    public void checkTaskDateSchedule(Long taskId, Long personId, Long scheduleId, Long taskTypeId, String taskDate) {
        List taskPersons = this.taskPersonDao.findByPersonId(personId);
        SecurityCompanySchedule choiseSchedule = this.securityCompanyScheduleService.findById(scheduleId);
        Long choiseStartTime = Long.parseLong(choiseSchedule.getStartTime().replaceAll("[-\\s:]", ""));
        Long choiseEndTime = Long.parseLong(choiseSchedule.getEndTime().replaceAll("[-\\s:]", ""));
        for (TaskPerson taskPerson : taskPersons) {
            for (TaskPersonSchedule taskPersonSchedule : taskPerson.getScheduleList()) {
                String checkDate = taskPersonSchedule.getTaskDate();
                String webDate = taskDate;
                if (taskTypeId == 2L) {
                    if (checkDate.indexOf("\u5468") > -1) {
                        webDate = DateUtil.getWeekOfDate((String)taskDate);
                    }
                } else if (taskDate.indexOf("\u5468") > -1) {
                    if (checkDate.indexOf("\u5468") < 0) {
                        checkDate = DateUtil.getWeekOfDate((String)checkDate);
                    }
                } else if (checkDate.indexOf("\u5468") > -1) {
                    webDate = DateUtil.getWeekOfDate((String)taskDate);
                }
                if (!checkDate.equals(webDate)) continue;
                List schedules = taskPersonSchedule.getScheduleDetail();
                for (SecurityCompanySchedule securityCompanySchedule : schedules) {
                    Long startTime = Long.parseLong(securityCompanySchedule.getStartTime().replaceAll("[-\\s:]", ""));
                    Long endTime = Long.parseLong(securityCompanySchedule.getEndTime().replaceAll("[-\\s:]", ""));
                    if (taskId != null && taskPerson.getTaskId().equals(taskId) || !(choiseStartTime >= startTime && choiseStartTime <= endTime || choiseEndTime >= startTime && choiseEndTime <= endTime || startTime >= choiseStartTime && startTime <= choiseEndTime) && (endTime < choiseStartTime || endTime > choiseEndTime)) continue;
                    Task task = this.findById(taskPerson.getTaskId());
                    throw new ArsException("\u4e0e\u4efb\u52a1\uff1a" + task.getName() + "<br>\u65e5\u671f\uff1a" + taskPersonSchedule.getTaskDate() + "<br>\u73ed\u6b21\uff1a" + securityCompanySchedule.getName() + "<br>\u65f6\u95f4:" + securityCompanySchedule.getStartTime() + "-" + securityCompanySchedule.getEndTime() + "\u51b2\u7a81");
                }
            }
        }
    }

    public List<Task> findTaskList(Long personId, Long taskStatus, Integer minutes) {
        return this.taskDao.findTaskList(personId, taskStatus, minutes);
    }

    public Task findDetailByIdPerson(Long taskId, Long personId) {
        return this.taskDao.findDetailByIdPerson(taskId, personId);
    }

    public TaskSearchDto searchForFeedback(TaskSearchDto dto) {
        List data = this.taskDao.searchForFeedback(dto);
        Long count = this.taskDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public UrgentTaskDTO findUrgentTask(UrgentTaskDTO dto) {
        List data = this.taskDao.findUrgentTask(dto);
        Long count = this.taskDao.countUrgentTask(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public void saveUrgentTaskPerson(Long taskid, Long personid) {
        Task task = this.taskDao.findById(taskid);
        if (task.getPersonList() != null && task.getPersonList().size() == task.getNeednum().intValue()) {
            throw new ArsException("\u4efb\u52a1\u63a5\u53d7\u4eba\u6570\u5df2\u6ee1\uff01");
        }
        SecurityPerson person = this.personDao.findById(personid);
        TaskPerson taskPerson = new TaskPerson();
        taskPerson.setTaskId(taskid);
        taskPerson.setPerson(person);
        taskPerson.setCreateTime(new Date());
        taskPerson.setNativeCode(this.arsUtil.getCurrentNatvie());
        taskPerson.setUpdateTime(task.getCreateTime());
        this.taskPersonDao.save(taskPerson);
        this.appNoticeService.saveByTaskPerson(task, taskPerson);
    }

    public boolean saveUrgentTaskPerson(Task task, SecurityPerson person) {
        TaskPerson taskPerson;
        List personList = this.taskPersonDao.findByTaskId(task.getId());
        if (personList != null && personList.size() > 0) {
            int neednum = 0;
            for (TaskPerson taskPerson2 : personList) {
                if (taskPerson2.getAcceptStatus() == null || taskPerson2.getAcceptStatus() != 1) continue;
                ++neednum;
            }
            if (neednum == task.getNeednum()) {
                return false;
            }
        }
        if ((taskPerson = this.taskPersonDao.findByTaskIdPersonId(task.getId(), person.getId())) != null) {
            if (taskPerson.getAcceptStatus() == 0) {
                new Thread(() -> {
                    try {
                        User u = this.userDao.findById(person.getId());
                        String registrationID = "";
                        registrationID = StringUtil.isNotEmpty((String)u.getRegistrationID()) ? u.getRegistrationID() : u.getId().toString();
                        if (task != null && task.getTaskType() != null && task.getTaskType().getId() != null && task.getTaskType().getId() == 4L) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("taskId", task.getId().toString());
                            map.put("urgentMark", "true");
                            JPushUtil.sendMessage((String)"\u60a8\u6709\u65b0\u4efb\u52a1\u5230\u8fbe\uff0c\u8bf7\u70b9\u51fb\u8fdb\u884c\u67e5\u770b", (String)("\u4efb\u52a1\u540d\u79f0\uff1a" + task.getName()), (String)registrationID, map);
                        } else {
                            JPushUtil.sendMessage((String)"\u60a8\u6709\u65b0\u4efb\u52a1\u5230\u8fbe\uff0c\u8bf7\u70b9\u51fb\u8fdb\u884c\u67e5\u770b", (String)("\u4efb\u52a1\u540d\u79f0\uff1a" + task.getName()), (String)registrationID);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
            }
            return true;
        }
        taskPerson = new TaskPerson();
        taskPerson.setTaskId(task.getId());
        taskPerson.setPerson(person);
        taskPerson.setAcceptStatus(Integer.valueOf(0));
        taskPerson.setCreateTime(new Date());
        taskPerson.setNativeCode(task.getNativeCode());
        taskPerson.setUpdateTime(task.getCreateTime());
        this.taskPersonDao.save(taskPerson);
        this.appNoticeService.saveByTaskPerson(task, taskPerson);
        TaskPersonSchedule taskPersonSchedule = new TaskPersonSchedule();
        taskPersonSchedule.setTaskDate(task.getStartDate());
        taskPersonSchedule.setTaskPersonId(taskPerson.getId());
        taskPersonSchedule.setNativeCode(task.getNativeCode());
        this.taskPersonScheduleDao.save(taskPersonSchedule);
        SecurityCompanySchedule securityCompanySchedule = new SecurityCompanySchedule();
        securityCompanySchedule.setId(Long.valueOf(1L));
        TaskPersonScheduleDetail taskPersonScheduleDetail = new TaskPersonScheduleDetail();
        taskPersonScheduleDetail.setNativeCode(task.getNativeCode());
        taskPersonScheduleDetail.setPersonScheduleId(taskPersonSchedule.getId());
        taskPersonScheduleDetail.setSchedule(securityCompanySchedule);
        taskPersonScheduleDetail.setScheduleId(Long.valueOf(1L));
        this.taskPersonScheduleDao.saveDetail(taskPersonScheduleDetail);
        new Thread(() -> {
            try {
                User u = this.userDao.findById(person.getId());
                String registrationID = "";
                registrationID = StringUtil.isNotEmpty((String)u.getRegistrationID()) ? u.getRegistrationID() : u.getId().toString();
                if (task != null && task.getTaskType() != null && task.getTaskType().getId() != null && task.getTaskType().getId() == 4L) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("taskId", task.getId().toString());
                    map.put("urgentMark", "true");
                    JPushUtil.sendMessage((String)"\u60a8\u6709\u65b0\u4efb\u52a1\u5230\u8fbe\uff0c\u8bf7\u70b9\u51fb\u8fdb\u884c\u67e5\u770b", (String)("\u4efb\u52a1\u540d\u79f0\uff1a" + task.getName()), (String)registrationID, map);
                } else {
                    JPushUtil.sendMessage((String)"\u60a8\u6709\u65b0\u4efb\u52a1\u5230\u8fbe\uff0c\u8bf7\u70b9\u51fb\u8fdb\u884c\u67e5\u770b", (String)("\u4efb\u52a1\u540d\u79f0\uff1a" + task.getName()), (String)registrationID);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
        return true;
    }

    public void endUrgentTaskMessage(Long taskid) {
        Task task = this.taskDao.findById(taskid);
        if (task == null) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0cID:" + taskid);
        }
        List list = this.feedbackDao.findByTaskId(taskid);
    }

    public void endUrgentTask(Long taskid) {
        Task task = this.taskDao.findById(taskid);
        if (task == null) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\uff0cID:" + taskid);
        }
        TaskStatus status = new TaskStatus();
        status.setId(Long.valueOf(3L));
        task.setTaskStatus(status);
        Date date = new Date();
        Timestamp nousedate = new Timestamp(date.getTime());
        task.setEndDate(nousedate.toString().substring(0, 19));
        task.setUpdateTime(new Date());
        this.taskDao.update(task);
        List taskperson = this.taskPersonDao.findByTaskId(taskid);
        if (taskperson != null && taskperson.size() > 0) {
            for (TaskPerson tp : taskperson) {
                if (tp.getAcceptStatus() == 0) {
                    tp.setAcceptStatus(Integer.valueOf(4));
                    tp.setRejectReason("\u7d27\u6025\u4efb\u52a1\u8d85\u65f6\u6388\u53d7\u72b6\u6001\uff01\uff01\uff01");
                    tp.setUpdateTime(new Date());
                } else if (tp.getAcceptStatus() == 1) {
                    tp.setAcceptStatus(Integer.valueOf(3));
                    tp.setUpdateTime(new Date());
                }
                this.taskPersonDao.update(tp);
            }
        }
        List list = this.feedbackDao.findByTaskId(taskid);
        for (TaskFeedback taskfeedback : list) {
            taskfeedback.setTaskStatus(status);
            taskfeedback.setEndTime(DateUtil.convertStringToDate((String)task.getEndDate()));
            taskfeedback.setEndTime(new Date());
            taskfeedback.setUpdateTime(new Date());
            this.feedbackDao.update(taskfeedback);
        }
    }

    public TaskPerson findByPersonIdAndTaskId(Long personId, Long taskId) {
        return this.taskPersonDao.findByTaskIdPersonId(taskId, personId);
    }

    public List<HotMap> findCompanyHot(Long companyid) {
        return this.taskDao.findCompanyHot(companyid);
    }

    public List<HotMap> findPersonHot(Long personid) {
        return this.taskDao.findPersonHot(personid);
    }

    public TaskSearchDto searchForManage(TaskSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user.getPlatform() == 2) {
            SecurityCompany company = this.companyDao.findByUserid(user.getId());
            dto.setCompanyId(company.getId());
        }
        List data = this.taskDao.searchForManage(dto);
        Long count = this.taskDao.searchCountForManage(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public void sendUrgentTask() {
        List taskList = this.taskDao.findForSendUrgentMsg();
        for (Task task : taskList) {
            UrgentTaskThread taskThread = new UrgentTaskThread();
            taskThread.setMinute(6000);
            taskThread.setTaskDao(this.taskDao);
            taskThread.setPersonDao(this.personDao);
            taskThread.setTaskService(this);
            taskThread.setTaskId(task.getId());
            taskThread.run();
        }
    }

    public void exportTask(Task task, File file) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet1 = wb.createSheet("\u4efb\u52a1\u4fe1\u606f");
            String[] handers = new String[]{"id", "active", "create_time", "update_time", "update_by", "native_code", "company_id", "task_level", "task_type", "task_catalog", "creater", "area", "address", "longitude", "latitude", "scope", "detail", "task_status", "start_date", "end_date", "is_repeat", "auto_holiday", "urgenttype", "neednum", "urgentdegree", "peopletype", "sendcount", "areacode", "rawid", "inrawid", "name"};
            HSSFRow rowFirst = sheet1.createRow(0);
            CellStyle style = ExcelUtil.getCommonTitleStyle((HSSFWorkbook)wb);
            CellStyle stringStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
            for (int i = 0; i < handers.length; ++i) {
                HSSFCell cell = rowFirst.createCell(i);
                sheet1.setColumnWidth(i, 5000);
                sheet1.setDefaultColumnStyle(i, stringStyle);
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]);
            }
            int index = 1;
            HSSFRow row = null;
            CellStyle contentStyle = ExcelUtil.getStringStyle((HSSFWorkbook)wb);
            if (null != task) {
                row = sheet1.createRow(index++);
                HSSFCell nameCell0 = row.createCell(0);
                nameCell0.setCellStyle(contentStyle);
                nameCell0.setCellValue((double)task.getId().longValue());
                HSSFCell nameCell1 = row.createCell(1);
                nameCell1.setCellStyle(contentStyle);
                if (task.getActive() != null) {
                    nameCell1.setCellValue(task.getActive().booleanValue());
                }
                HSSFCell nameCell2 = row.createCell(2);
                nameCell2.setCellStyle(contentStyle);
                if (task.getCreateTime() != null) {
                    nameCell2.setCellValue(DateUtil.convertDateToString((Date)task.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                HSSFCell nameCell3 = row.createCell(3);
                nameCell3.setCellStyle(contentStyle);
                if (task.getUpdateTime() != null) {
                    nameCell3.setCellValue(DateUtil.convertDateToString((Date)task.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                HSSFCell nameCell4 = row.createCell(4);
                nameCell4.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getUpdateBy())) {
                    nameCell4.setCellValue(task.getUpdateBy());
                }
                HSSFCell nameCell5 = row.createCell(5);
                nameCell5.setCellStyle(contentStyle);
                if (task.getNativeCode() != null) {
                    nameCell5.setCellValue((double)task.getNativeCode().longValue());
                }
                HSSFCell nameCell6 = row.createCell(6);
                nameCell6.setCellStyle(contentStyle);
                if (task.getCompany().getId() != null) {
                    nameCell6.setCellValue((double)task.getCompany().getId().longValue());
                }
                HSSFCell nameCell7 = row.createCell(7);
                nameCell7.setCellStyle(contentStyle);
                if (task.getTaskLevel() != null) {
                    nameCell7.setCellValue((double)task.getTaskLevel().getId().longValue());
                }
                HSSFCell nameCell8 = row.createCell(8);
                nameCell8.setCellStyle(contentStyle);
                if (task.getTaskType() != null) {
                    nameCell8.setCellValue((double)task.getTaskType().getId().longValue());
                }
                HSSFCell nameCell9 = row.createCell(9);
                nameCell9.setCellStyle(contentStyle);
                if (task.getTaskCatalog() != null) {
                    nameCell9.setCellValue((double)task.getTaskCatalog().getId().longValue());
                }
                HSSFCell nameCell10 = row.createCell(10);
                nameCell10.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getCreater())) {
                    nameCell10.setCellValue(task.getCreater());
                }
                HSSFCell nameCell11 = row.createCell(11);
                nameCell11.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getArea())) {
                    nameCell11.setCellValue(task.getArea());
                }
                HSSFCell nameCell12 = row.createCell(12);
                nameCell12.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getAddress())) {
                    nameCell12.setCellValue(task.getAddress());
                }
                HSSFCell nameCell13 = row.createCell(13);
                nameCell13.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getLongitude())) {
                    nameCell13.setCellValue(task.getLongitude());
                }
                HSSFCell nameCell14 = row.createCell(14);
                nameCell14.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getLatitude())) {
                    nameCell14.setCellValue(task.getLatitude());
                }
                HSSFCell nameCell15 = row.createCell(15);
                nameCell15.setCellStyle(contentStyle);
                if (task.getScope() != null) {
                    nameCell15.setCellValue((double)task.getScope().intValue());
                }
                HSSFCell nameCell16 = row.createCell(16);
                nameCell16.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getDetail())) {
                    nameCell16.setCellValue(task.getDetail());
                }
                HSSFCell nameCell17 = row.createCell(17);
                nameCell17.setCellStyle(contentStyle);
                if (task.getTaskStatus() != null) {
                    nameCell17.setCellValue((double)task.getTaskStatus().getId().longValue());
                }
                HSSFCell nameCell18 = row.createCell(18);
                nameCell18.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getStartDate())) {
                    nameCell18.setCellValue(task.getStartDate());
                }
                HSSFCell nameCell19 = row.createCell(19);
                nameCell19.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getEndDate())) {
                    nameCell19.setCellValue(task.getEndDate());
                }
                HSSFCell nameCell20 = row.createCell(20);
                nameCell20.setCellStyle(contentStyle);
                nameCell20.setCellValue(task.isRepeat());
                HSSFCell nameCell21 = row.createCell(21);
                nameCell21.setCellStyle(contentStyle);
                nameCell21.setCellValue(task.isAutoHoliday());
                HSSFCell nameCell22 = row.createCell(22);
                nameCell22.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getUrgenttype())) {
                    nameCell22.setCellValue(task.getUrgenttype());
                }
                HSSFCell nameCell23 = row.createCell(23);
                nameCell23.setCellStyle(contentStyle);
                if (task.getNeednum() != null) {
                    nameCell23.setCellValue((double)task.getNeednum().intValue());
                }
                HSSFCell nameCell24 = row.createCell(24);
                nameCell24.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getUrgentdegree())) {
                    nameCell24.setCellValue(task.getUrgentdegree());
                }
                HSSFCell nameCell25 = row.createCell(25);
                nameCell25.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getPeopletype())) {
                    nameCell25.setCellValue(task.getPeopletype());
                }
                HSSFCell nameCell26 = row.createCell(26);
                nameCell26.setCellStyle(contentStyle);
                if (task.getSendcount() != null) {
                    nameCell26.setCellValue((double)task.getSendcount().intValue());
                }
                HSSFCell nameCell27 = row.createCell(27);
                nameCell27.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getAreacode())) {
                    nameCell27.setCellValue(task.getAreacode());
                }
                HSSFCell nameCell28 = row.createCell(28);
                nameCell28.setCellStyle(contentStyle);
                if (StringUtil.isNotEmpty((String)task.getName())) {
                    nameCell28.setCellValue(task.getName());
                }
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> importTask(File excel) throws Exception {
        ArrayList saveList;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        User loginUser = this.arsUtil.getCurrentUser();
        if (loginUser != null && loginUser.getPlatform() == 1) {
            saveList = new ArrayList();
            ArrayList faildList = new ArrayList();
            FileInputStream inStream = new FileInputStream(excel);
            Workbook workBook = WorkbookFactory.create((InputStream)inStream);
            Sheet sheet = workBook.getSheetAt(0);
            boolean flag = true;
            int i = 1;
            while (flag) {
                Row row = sheet.getRow(i);
                if (row != null) {
                    HashMap<String, String> data = new HashMap<String, String>();
                    try {
                        Datasync dbdatasync;
                        Long id = Long.valueOf(ExcelUtil.getCellValue((Cell)row.getCell(0)));
                        data.put("id", id.toString());
                        String active = ExcelUtil.getCellValue((Cell)row.getCell(1));
                        data.put("active", active);
                        String create_time = ExcelUtil.getCellValue((Cell)row.getCell(2));
                        data.put("create_time", create_time);
                        String update_time = ExcelUtil.getCellValue((Cell)row.getCell(3));
                        data.put("update_time", update_time);
                        String update_by = ExcelUtil.getCellValue((Cell)row.getCell(4));
                        data.put("update_by", update_by);
                        String native_code = ExcelUtil.getCellValue((Cell)row.getCell(5));
                        data.put("native_code", native_code);
                        String company_id = ExcelUtil.getCellValue((Cell)row.getCell(6));
                        data.put("company_id", company_id);
                        String task_level = ExcelUtil.getCellValue((Cell)row.getCell(7));
                        data.put("task_level", task_level);
                        String task_type = ExcelUtil.getCellValue((Cell)row.getCell(8));
                        data.put("task_type", task_type);
                        String task_catalog = ExcelUtil.getCellValue((Cell)row.getCell(9));
                        data.put("task_catalog", task_catalog);
                        String creater = ExcelUtil.getCellValue((Cell)row.getCell(10));
                        data.put("creater", creater);
                        String area = ExcelUtil.getCellValue((Cell)row.getCell(11));
                        data.put("area", area);
                        String address = ExcelUtil.getCellValue((Cell)row.getCell(12));
                        data.put("address", address);
                        String longitude = ExcelUtil.getCellValue((Cell)row.getCell(13));
                        data.put("longitude", longitude);
                        String latitude = ExcelUtil.getCellValue((Cell)row.getCell(14));
                        data.put("latitude", latitude);
                        String scope = ExcelUtil.getCellValue((Cell)row.getCell(15));
                        data.put("scope", scope);
                        String detail = ExcelUtil.getCellValue((Cell)row.getCell(16));
                        data.put("detail", detail);
                        String task_status = ExcelUtil.getCellValue((Cell)row.getCell(17));
                        data.put("task_status", task_status);
                        String start_date = ExcelUtil.getCellValue((Cell)row.getCell(18));
                        data.put("start_date", start_date);
                        String end_date = ExcelUtil.getCellValue((Cell)row.getCell(19));
                        data.put("end_date", end_date);
                        String is_repeat = ExcelUtil.getCellValue((Cell)row.getCell(20));
                        data.put("is_repeat", is_repeat);
                        String auto_holiday = ExcelUtil.getCellValue((Cell)row.getCell(21));
                        data.put("auto_holiday", auto_holiday);
                        String urgenttype = ExcelUtil.getCellValue((Cell)row.getCell(22));
                        data.put("urgenttype", urgenttype);
                        String neednum = ExcelUtil.getCellValue((Cell)row.getCell(23));
                        data.put("neednum", neednum);
                        String urgentdegree = ExcelUtil.getCellValue((Cell)row.getCell(24));
                        data.put("urgentdegree", urgentdegree);
                        String peopletype = ExcelUtil.getCellValue((Cell)row.getCell(25));
                        data.put("peopletype", peopletype);
                        String sendcount = ExcelUtil.getCellValue((Cell)row.getCell(26));
                        data.put("sendcount", sendcount);
                        String areacode = ExcelUtil.getCellValue((Cell)row.getCell(27));
                        data.put("areacode", areacode);
                        String name = ExcelUtil.getCellValue((Cell)row.getCell(30));
                        data.put("name", name);
                        Task task = new Task();
                        task.setId(id);
                        if (StringUtil.isNotEmpty((String)active)) {
                            task.setActive(Boolean.valueOf(!active.equals("FALSE")));
                        }
                        if (StringUtil.isNotEmpty((String)create_time)) {
                            task.setCreateTime(DateUtil.convertStringToDate((String)create_time));
                        }
                        if (StringUtil.isNotEmpty((String)update_by)) {
                            task.setUpdateBy(update_by);
                        }
                        if (StringUtil.isNotEmpty((String)update_time)) {
                            task.setUpdateTime(DateUtil.convertStringToDate((String)update_time));
                        }
                        if (StringUtil.isNotEmpty((String)native_code)) {
                            task.setNativeCode(Long.valueOf(Long.parseLong(native_code)));
                        }
                        if (StringUtil.isNotEmpty((String)company_id)) {
                            task.setCompany_id(Integer.valueOf(Integer.parseInt(company_id)));
                        }
                        if (StringUtil.isNotEmpty((String)task_level)) {
                            TaskLevel taskLevel = new TaskLevel();
                            taskLevel.setId(Long.valueOf(Long.parseLong(task_level)));
                            task.setTaskLevel(taskLevel);
                        }
                        if (StringUtil.isNotEmpty((String)task_type)) {
                            TaskType taskType = new TaskType();
                            taskType.setId(Long.valueOf(Long.parseLong(task_type)));
                            task.setTaskType(taskType);
                        }
                        if (StringUtil.isNotEmpty((String)task_catalog)) {
                            TaskCatalog TaskCatalog2 = new TaskCatalog();
                            TaskCatalog2.setId(Long.valueOf(Long.parseLong(task_catalog)));
                            task.setTaskCatalog(TaskCatalog2);
                        }
                        if (StringUtil.isNotEmpty((String)creater)) {
                            task.setCreater(creater);
                        }
                        if (StringUtil.isNotEmpty((String)area)) {
                            task.setArea(area);
                        }
                        if (StringUtil.isNotEmpty((String)address)) {
                            task.setAddress(address);
                        }
                        if (StringUtil.isNotEmpty((String)longitude)) {
                            task.setLongitude(longitude);
                        }
                        if (StringUtil.isNotEmpty((String)latitude)) {
                            task.setLatitude(latitude);
                        }
                        if (StringUtil.isNotEmpty((String)scope)) {
                            task.setScope(Integer.valueOf(Integer.parseInt(scope)));
                        }
                        if (StringUtil.isNotEmpty((String)detail)) {
                            task.setDetail(detail);
                        }
                        if (StringUtil.isNotEmpty((String)task_status)) {
                            TaskStatus taskStatus = new TaskStatus();
                            taskStatus.setId(Long.valueOf(Long.parseLong(task_status)));
                            task.setTaskStatus(taskStatus);
                        }
                        if (StringUtil.isNotEmpty((String)start_date)) {
                            task.setStartDate(start_date);
                        }
                        if (StringUtil.isNotEmpty((String)end_date)) {
                            task.setEndDate(end_date);
                        }
                        if (StringUtil.isNotEmpty((String)is_repeat)) {
                            task.setRepeat(!is_repeat.equals("FALSE"));
                        }
                        if (StringUtil.isNotEmpty((String)auto_holiday)) {
                            task.setAutoHoliday(!auto_holiday.equals("FALSE"));
                        }
                        if (StringUtil.isNotEmpty((String)urgenttype)) {
                            task.setUrgenttype(urgenttype);
                        }
                        if (StringUtil.isNotEmpty((String)neednum)) {
                            task.setNeednum(Integer.valueOf(Integer.parseInt(neednum)));
                        }
                        if (StringUtil.isNotEmpty((String)urgentdegree)) {
                            task.setUrgentdegree(urgentdegree);
                        }
                        if (StringUtil.isNotEmpty((String)peopletype)) {
                            task.setPeopletype(peopletype);
                        }
                        if (StringUtil.isNotEmpty((String)sendcount)) {
                            task.setSendcount(Integer.valueOf(Integer.parseInt(sendcount)));
                        }
                        if (StringUtil.isNotEmpty((String)areacode)) {
                            task.setAreacode(areacode);
                        }
                        if (StringUtil.isNotEmpty((String)name)) {
                            task.setName(name);
                        }
                        this.logger.info("saveOrupdate... " + task);
                        boolean isSave = false;
                        if (task.getId() == null) {
                            throw new ArsException("id\u7f3a\u5931");
                        }
                        Task dbTask = this.taskDao.findById(task.getId());
                        if (dbTask == null) {
                            this.taskDao.save(task);
                        } else if (task.getUpdateTime().getTime() > dbTask.getUpdateTime().getTime()) {
                            task.setId(dbTask.getId());
                            this.taskDao.update(task);
                            isSave = true;
                        }
                        if (isSave && (dbdatasync = this.datasyncDao.findByBid(id)) != null) {
                            dbdatasync.setState("2");
                            dbdatasync.setUpdateTime(new Date());
                            this.datasyncDao.update(dbdatasync);
                        }
                    }
                    catch (Exception e) {
                        faildList.add(data);
                        this.logger.error("\u5bfc\u5165\u9519\u8bef\uff1a" + (String)data.get("id"), (Throwable)e);
                    }
                } else {
                    flag = false;
                }
                ++i;
            }
        } else {
            throw new RuntimeException("\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u9519\u8bef, user:" + loginUser);
        }
        resultMap.put("successIds", saveList);
        return resultMap;
    }

    public TaskDto findTaskDetail(TaskDetailSearchDto taskDetailDto) {
        TaskDto taskDto = this.taskDao.findTaskDetail(taskDetailDto);
        if (taskDto != null) {
            List feedbacks;
            TaskFeedBackDto nearFeedBack;
            if (taskDto.getTaskType().getId() == 1L) {
                if (taskDto.isRepeat().booleanValue()) {
                    taskDto.setStartDate(taskDto.getCreateTime());
                } else {
                    TaskPerson taskPerson = this.taskPersonDao.findByTaskIdPersonId(taskDetailDto.getTaskid(), taskDetailDto.getPersonid());
                    if (taskPerson.getScheduleList() != null && taskPerson.getScheduleList().size() > 0) {
                        Object taskDateStr = ((TaskPersonSchedule)taskPerson.getScheduleList().get(0)).getTaskDate();
                        Date taskDate = DateUtil.convertStringToDate((String)taskDateStr);
                        taskDateStr = DateUtil.convertDateToString((Date)taskDate, (String)"yyyy-MM") + "-01 00:00:00";
                        taskDate = DateUtil.convertStringToDate((String)taskDateStr);
                        int monthDays = DateUtil.getDaysOfMonth((Date)taskDate);
                        Date createTime = DateUtil.convertStringToDate((String)taskDto.getCreateTime());
                        if (taskDate.getTime() > createTime.getTime()) {
                            taskDto.setStartDate((String)taskDateStr);
                        } else {
                            taskDto.setStartDate(taskDto.getCreateTime());
                        }
                        taskDto.setEndDate(DateUtil.convertDateToString((Date)taskDate, (String)"yyyy-MM") + "-" + (monthDays > 9 ? Integer.valueOf(monthDays) : "0" + monthDays) + " 00:00:00");
                    }
                }
            }
            if ((nearFeedBack = this.feedbackDao.findNearFeedBack_back(taskDetailDto)) == null) {
                nearFeedBack = this.feedbackDao.findNearFeedBack_before(taskDetailDto);
            }
            taskDto.setNearfeedback(nearFeedBack);
            if (taskDto.getPersons() != null && taskDto.getPersons().size() > 0) {
                for (TaskPersonDto taskPersonDto : taskDto.getPersons()) {
                    taskPersonDto.setInitialname(FirstLetterUtil.getFirstLetter((String)taskPersonDto.getRealname().substring(0, 1)));
                }
            }
            if (nearFeedBack != null) {
                taskDetailDto.setTaskdate(DateUtil.convertDateToString((Date)DateUtil.convertStringToDate((String)nearFeedBack.getTaskDate()), (String)"yyyy-MM"));
                feedbacks = this.feedbackService.findTaskFeedbasksByTask(taskDetailDto, taskDto);
                taskDto.setFeedbacks(feedbacks);
            } else if (taskDto.getAcceptStatus().equals("0") || taskDto.getAcceptStatus().equals("2") || taskDto.getAcceptStatus().equals("4")) {
                taskDetailDto.setTaskdate(DateUtil.convertDateToString((Date)new Date(), (String)"yyyy-MM"));
                feedbacks = this.feedbackService.findTaskFeedbasksByTask(taskDetailDto, taskDto);
                if (feedbacks != null && feedbacks.size() > 0) {
                    taskDto.setFeedbacks(feedbacks);
                    TaskFeedBackDto nearMinFeedBackDto = null;
                    TaskFeedBackDto nearMaxFeedBackDto = null;
                    for (TaskFeedBackDto taskFeedBackDto : feedbacks) {
                        if (DateUtil.convertStringToDate((String)taskFeedBackDto.getTaskDate()).getTime() >= DateUtil.convertStringToDate((String)DateUtil.getCurrentDate()).getTime()) {
                            if (nearMinFeedBackDto == null) {
                                nearMinFeedBackDto = taskFeedBackDto;
                                continue;
                            }
                            if (DateUtil.convertStringToDate((String)nearMinFeedBackDto.getTaskDate()).getTime() < DateUtil.convertStringToDate((String)taskFeedBackDto.getTaskDate()).getTime()) continue;
                            nearMinFeedBackDto = taskFeedBackDto;
                            continue;
                        }
                        if (nearMaxFeedBackDto == null) {
                            nearMaxFeedBackDto = taskFeedBackDto;
                            continue;
                        }
                        if (DateUtil.convertStringToDate((String)nearMaxFeedBackDto.getTaskDate()).getTime() > DateUtil.convertStringToDate((String)taskFeedBackDto.getTaskDate()).getTime()) continue;
                        nearMaxFeedBackDto = taskFeedBackDto;
                    }
                    taskDto.setNearfeedback(nearMinFeedBackDto);
                    if (nearMinFeedBackDto == null) {
                        taskDto.setNearfeedback(nearMaxFeedBackDto);
                    }
                }
            }
        }
        return taskDto;
    }

    public TaskSearchDto findTaskListByPersonid(TaskSearchDto taskSearchDto) {
        TaskSearchDto resultDto = new TaskSearchDto();
        List list = this.taskDao.findTaskListByPersonid(taskSearchDto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.taskDao.countTaskListByPersonid(taskSearchDto));
        return resultDto;
    }

    public TaskSearchDto findTaskListByPersonid_V109(TaskSearchDto taskSearchDto) {
        TaskSearchDto resultDto = new TaskSearchDto();
        List list = this.taskDao.findTaskListByPersonid_V109(taskSearchDto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.taskDao.countTaskListByPersonid_V109(taskSearchDto));
        return resultDto;
    }

    public TaskDto findTaskDetailV109(TaskDetailSearchDto taskDetailDto) {
        TaskDto taskDto = this.taskDao.findTaskDetail_V109(taskDetailDto);
        if (taskDto != null) {
            taskDto.setPersons(this.taskPersonDao.findTaskPersonsByTaskId(taskDto.getTaskid()));
            if (taskDto.getTaskType().getId() == 1L) {
                if (taskDto.isRepeat().booleanValue()) {
                    taskDto.setStartDate(taskDto.getCreateTime());
                } else {
                    TaskPerson taskPerson = this.taskPersonDao.findByTaskIdPersonId(taskDetailDto.getTaskid(), taskDetailDto.getPersonid());
                    if (taskPerson.getScheduleList() != null && taskPerson.getScheduleList().size() > 0) {
                        Object taskDateStr = ((TaskPersonSchedule)taskPerson.getScheduleList().get(0)).getTaskDate();
                        Date taskDate = DateUtil.convertStringToDate((String)taskDateStr);
                        taskDateStr = DateUtil.convertDateToString((Date)taskDate, (String)"yyyy-MM") + "-01 00:00:00";
                        taskDate = DateUtil.convertStringToDate((String)taskDateStr);
                        int monthDays = DateUtil.getDaysOfMonth((Date)taskDate);
                        Date createTime = DateUtil.convertStringToDate((String)taskDto.getCreateTime());
                        if (taskDate.getTime() > createTime.getTime()) {
                            taskDto.setStartDate((String)taskDateStr);
                        } else {
                            taskDto.setStartDate(taskDto.getCreateTime());
                        }
                        taskDto.setEndDate(DateUtil.convertDateToString((Date)taskDate, (String)"yyyy-MM") + "-" + (monthDays > 9 ? Integer.valueOf(monthDays) : "0" + monthDays) + " 00:00:00");
                    }
                }
            }
            if (taskDto.getTaskType().getId() == 4L) {
                taskDto.setUrgent(Boolean.valueOf(true));
            } else {
                taskDto.setUrgent(Boolean.valueOf(false));
            }
            TaskFeedBackDto nearFeedBack = this.feedbackDao.findNearFeedBack_back(taskDetailDto);
            if (nearFeedBack == null) {
                nearFeedBack = this.feedbackDao.findNearFeedBack_before(taskDetailDto);
            }
            taskDto.setNearfeedback(nearFeedBack);
            if (taskDto.getPersons() != null && taskDto.getPersons().size() > 0) {
                for (TaskPersonDto taskPersonDto : taskDto.getPersons()) {
                    taskPersonDto.setInitialname(FirstLetterUtil.getFirstLetter((String)taskPersonDto.getRealname().substring(0, 1)));
                }
            }
            if (nearFeedBack != null) {
                taskDetailDto.setTaskdate(DateUtil.convertDateToString((Date)DateUtil.convertStringToDate((String)nearFeedBack.getTaskDate()), (String)"yyyy-MM"));
                List feedbacks = this.feedbackService.findTaskFeedbasksByTask_V109(taskDetailDto);
                taskDto.setFeedbacks(feedbacks);
            }
        }
        return taskDto;
    }
}

