/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.task.ComTempTaskDao;
import com.bcxin.ars.dao.task.ComTempTaskPerDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.ComTempTaskPageSearchDto;
import com.bcxin.ars.dto.task.ComTempTaskDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComTempTask;
import com.bcxin.ars.model.task.ComTempTaskPer;
import com.bcxin.ars.service.task.ComTempTaskService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ComTempTask.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
public class ComTempTaskServiceImpl
implements ComTempTaskService {
    Logger logger = LoggerFactory.getLogger(ComTempTaskServiceImpl.class);
    @Autowired
    private ComTempTaskDao comTempTaskDao;
    @Autowired
    private ComTempTaskPerDao comTempTaskPerDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(ComTempTask comTempTask) {
        User currentUser = this.arsUtil.getCurrentUser();
        comTempTask.setUpdateTime(new Date());
        comTempTask.setUpdateBy(currentUser.getUsername());
        return this.comTempTaskDao.delete(comTempTask);
    }

    public int save(ComTempTask comTempTask) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (comTempTask.getComTempTaskId() == null) {
            comTempTask.setComTempTaskId(Long.valueOf(this.idWorker.nextId()));
            comTempTask.setCreateTime(new Date());
            SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
            comTempTask.setComId(company.getId());
        } else {
            ComTempTask dbComTempTask = this.comTempTaskDao.findById(comTempTask.getComTempTaskId());
            BeanUtils.copyPropertiesIgnore((Object)comTempTask, (Object)dbComTempTask, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbComTempTask, (Object)comTempTask, (Boolean)false);
        }
        comTempTask.setTaskStatus(Constants.COM_TASK_TASKSTATUS_NEW_3);
        if (comTempTask.getStartDate().getTime() <= System.currentTimeMillis() && comTempTask.getEndDate().getTime() >= System.currentTimeMillis()) {
            comTempTask.setTaskStatus(Constants.COM_TASK_TASKSTATUS_NEW_1);
        } else if (comTempTask.getEndDate().getTime() < System.currentTimeMillis()) {
            comTempTask.setTaskStatus(Constants.COM_TASK_TASKSTATUS_NEW_2);
        }
        comTempTask.setActive(Boolean.valueOf(true));
        comTempTask.setUpdateBy(currentUser.getUsername());
        comTempTask.setUpdateTime(new Date());
        comTempTask.setUpdateflag(Boolean.valueOf(true));
        comTempTask.setUserId(currentUser.getId());
        return this.comTempTaskDao.save(comTempTask);
    }

    public ComTempTask findById(Long id) {
        return this.comTempTaskDao.findById(id);
    }

    public void searchForPage(ComTempTaskPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        User currentUser = this.arsUtil.getCurrentUser();
        if (currentUser.getPlatform() == 2) {
            dto.setUserId(currentUser.getId());
        }
        this.comTempTaskDao.searchForPage(dto, page);
    }

    public void importBatch(List<ComTempTask> list) {
        List dbList = this.comTempTaskDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ComTempTask comTempTask : list) {
                comTempTask.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    comTempTask.setUpdateTime(DateUtil.dateAdd((int)6, (Date)comTempTask.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.comTempTaskDao.saveBatch(list);
        }
    }

    public List<ComTempTask> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comTempTaskDao.searchForDataSynchronization(dto);
    }

    public List<ComTempTask> findDSOutList(String startDate) {
        return this.comTempTaskDao.findDSOutList(startDate);
    }

    public List<ComTempTask> findByBatchId(List<ComTempTask> list) {
        return this.comTempTaskDao.findByBatchId(list);
    }

    public void updateSelective(ComTempTask comTempTask) {
        User currentUser = this.arsUtil.getCurrentUser();
        comTempTask.setUpdateTime(new Date());
        comTempTask.setUpdateBy(currentUser.getUsername());
        this.comTempTaskDao.updateSelective(comTempTask);
    }

    public void saveTaskPer(ComTempTaskDto comTempTask) {
        List perList = this.comTempTaskPerDao.findByComTempTask((ComTempTask)comTempTask);
        Map perMap = perList.stream().collect(Collectors.toMap(ComTempTaskPer::getPerId, Function.identity()));
        User currentUser = this.arsUtil.getCurrentUser();
        ComTempTaskPer taskPer = null;
        ArrayList<ComTempTaskPer> savePerList = new ArrayList<ComTempTaskPer>();
        for (Long perId : comTempTask.getPerIds()) {
            if (perMap.get(perId) != null) continue;
            taskPer = new ComTempTaskPer();
            taskPer.setComTempTaskPerId(Long.valueOf(this.idWorker.nextId()));
            taskPer.setComTempTaskId(comTempTask.getComTempTaskId());
            taskPer.setComId(comTempTask.getComId());
            taskPer.setPerId(perId);
            taskPer.setActive(Boolean.valueOf(true));
            taskPer.setUserId(currentUser.getId());
            taskPer.setCreateTime(new Date());
            taskPer.setUpdateTime(new Date());
            taskPer.setUpdateBy(currentUser.getUsername());
            savePerList.add(taskPer);
        }
        if (savePerList.size() > 0) {
            this.comTempTaskPerDao.saveBatch(savePerList);
        }
    }

    public void removePer(ComTempTaskPer comTempTaskPer) {
        comTempTaskPer.setUpdateBy(this.arsUtil.getCurrentUser().getUsername());
        comTempTaskPer.setUpdateTime(new Date());
        this.comTempTaskPerDao.delete(comTempTaskPer);
    }
}

