/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dao.task.ComTaskDaoAop;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.dao.task.ComTaskSchedulDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.task.ComTaskSearchDto;
import com.bcxin.ars.dto.task.ComTaskDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComTask;
import com.bcxin.ars.model.task.ComTaskPer;
import com.bcxin.ars.service.task.ComTaskService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ComTask.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class ComTaskServiceImpl
implements ComTaskService {
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ComTaskDao comTaskDao;
    @Autowired
    private ComTaskDaoAop comTaskDaoAop;
    @Autowired
    private ComTaskPerDao comTaskPerDao;
    @Autowired
    private ComTaskSchedulDao comTaskSchedulDao;
    @Autowired
    private ArsUtil arsUtil;

    public void search(ComTaskSearchDto dto, AjaxPageResponse<ComTaskDto> page) {
        String areaCode;
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (StringUtil.isNotEmpty((String)dto.getComAreaCode())) {
            areaCode = dto.getComAreaCode();
            if (areaCode.endsWith("0000")) {
                dto.setComAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {
                dto.setComAreaCode(areaCode.substring(0, 4) + "__");
            } else {
                dto.setComAreaCode(areaCode);
            }
        }
        if (StringUtil.isNotEmpty((String)dto.getTaskAreaCode())) {
            areaCode = dto.getTaskAreaCode();
            if (areaCode.endsWith("0000")) {
                dto.setTaskAreaCode(areaCode.substring(0, 2) + "____");
            } else if (areaCode.endsWith("00")) {
                dto.setTaskAreaCode(areaCode.substring(0, 4) + "__");
            } else {
                dto.setTaskAreaCode(areaCode);
            }
        }
        this.comTaskDao.searchV3(dto, page);
    }

    public ComTaskDto findDetailById(Long id) {
        return this.comTaskDao.findDetailById(id);
    }

    public ComTask findById(Long id) {
        return this.comTaskDao.findById(id);
    }

    public void save(ComTask comTask) {
        ComTask dbComTask = this.comTaskDao.findById(comTask.getComTaskId());
        if (dbComTask != null && "2".equals(dbComTask.getTaskStatusNew()) && !dbComTask.getTaskStatusNew().equals(comTask.getTaskStatus())) {
            this.comTaskPerDao.deleteByTaskId(dbComTask.getComTaskId());
            this.comTaskSchedulDao.deleteByTaskId(comTask.getComTaskId());
        }
        this.savePer(comTask, true);
        comTask.setUpdateTime(new Date());
        if (comTask.getBbdId() != null) {
            comTask.setOrgId(comTask.getBbdId());
            Police police = this.policeDao.findById(comTask.getBbdId());
            if (police != null) {
                comTask.setOrgName(police.getOrgname());
                comTask.setAreaCode(police.getAreacode());
            }
        }
        if (dbComTask != null) {
            BeanUtils.copyPropertiesIgnore((Object)comTask, (Object)dbComTask, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbComTask, (Object)comTask, (Boolean)false);
        }
        this.comTaskDaoAop.save(comTask);
        new Thread(() -> {
            this.comTaskDao.removeRelationTask(comTask);
            this.comTaskDao.relationTask(comTask);
            this.comTaskDao.updateTaskStatusNew(comTask.getComTaskId());
        }).start();
    }

    private void savePer(ComTask comTask, Boolean ignoreNull) {
        User currentUser = this.arsUtil.getCurrentUser();
        ArrayList newPerList = comTask.getPerList();
        if (ignoreNull.booleanValue() && (newPerList == null || newPerList.size() == 0)) {
            return;
        }
        if (newPerList == null) {
            newPerList = new ArrayList();
        }
        for (ComTaskPer comTaskPer : newPerList) {
            comTaskPer.setActive(Boolean.valueOf(true));
            comTaskPer.setUpdateBy(currentUser.getUsername());
            comTaskPer.setUpdateTime(new Date());
        }
        List dbPersonList = this.comTaskPerDao.findByTaskId(comTask.getComTaskId());
        if (dbPersonList.size() > 0) {
            ArrayList removeList = new ArrayList();
            CollectionUtils.addAll(removeList, (Object[])new Object[dbPersonList.size()]);
            Collections.copy(removeList, dbPersonList);
            removeList.removeAll(newPerList);
            if (removeList.size() > 0) {
                this.comTaskPerDao.deleteBatch(removeList);
                this.comTaskSchedulDao.deleteBatchByTaskIdPerIds(removeList);
            }
        }
        newPerList.removeAll(dbPersonList);
        if (newPerList.size() > 0) {
            this.comTaskPerDao.saveBatch(newPerList);
        }
    }

    public void importBatch(List<ComTask> list) {
        List dbList = this.comTaskDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list != null && list.size() > 0) {
            this.comTaskDaoAop.saveBatch(list);
        }
    }

    public List<ComTask> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comTaskDao.searchForDataSynchronization(dto);
    }

    public List<ComTask> findByContractId(String contractId) {
        return this.comTaskDao.findByContractId(contractId);
    }

    public List<ComTask> findByPerId(Long perId) {
        return this.comTaskDao.findByPerId(perId);
    }

    public void updateStatusV2() {
        this.comTaskDao.updateTaskStatusNew(null);
        this.comTaskDao.updateContractStatus();
    }

    public void addPersons(ComTask comTask, String perIdListStr) {
        User currentUser = this.arsUtil.getCurrentUser();
        ArrayList<ComTaskPer> perList = new ArrayList<ComTaskPer>();
        ComTaskPer comTaskPer = null;
        for (String perId : perIdListStr.split(",")) {
            comTaskPer = new ComTaskPer();
            comTaskPer.setComTaskId(comTask.getComTaskId());
            comTaskPer.setPerId(Long.valueOf(Long.parseLong(perId)));
            comTaskPer.setActive(Boolean.valueOf(true));
            comTaskPer.setCreateTime(new Date());
            comTaskPer.setUpdateBy(currentUser.getUsername());
            comTaskPer.setUpdateTime(new Date());
            perList.add(comTaskPer);
        }
        if (perList != null && perList.size() > 0) {
            comTask.setPerList(perList);
            this.comTaskPerDao.saveBatch(perList);
            new Thread(() -> this.comTaskDao.relationTask(comTask)).start();
        }
    }

    public void removePersons(ComTask comTask, String perIdListStr) {
        ArrayList<ComTaskPer> perList = new ArrayList<ComTaskPer>();
        ComTaskPer comTaskPer = null;
        for (String perId : perIdListStr.split(",")) {
            comTaskPer = new ComTaskPer();
            comTaskPer.setComTaskId(comTask.getComTaskId());
            comTaskPer.setPerId(Long.valueOf(Long.parseLong(perId)));
            perList.add(comTaskPer);
        }
        if (perList != null && perList.size() > 0) {
            comTask.setPerList(perList);
            this.comTaskPerDao.deleteBatch(perList);
            this.comTaskSchedulDao.deleteBatchByTaskIdPerIds(perList);
            new Thread(() -> this.comTaskDao.removeRelationTask(comTask)).start();
        }
    }

    public void delete(ComTask comTask) {
        comTask.setUpdateTime(new Date());
        comTask.setIsDelete("1");
        this.comTaskDaoAop.delete(comTask);
        this.comTaskPerDao.deleteByTaskId(comTask.getComTaskId());
        this.comTaskSchedulDao.deleteByTaskId(comTask.getComTaskId());
        new Thread(() -> this.comTaskDao.removeRelationTask(comTask)).start();
    }

    public void deleteBatch(Long[] taskIdList) {
        ArrayList<ComTask> taskList = new ArrayList<ComTask>();
        ComTask comTask = null;
        for (Long taskId : taskIdList) {
            comTask = new ComTask();
            comTask.setUpdateTime(new Date());
            comTask.setIsDelete("1");
            comTask.setComTaskId(taskId);
            taskList.add(comTask);
        }
        this.comTaskDaoAop.deleteBatch(taskList);
        this.comTaskPerDao.deleteByTaskIds(taskIdList);
        this.comTaskSchedulDao.deleteByTaskIds(taskIdList);
        new Thread(() -> this.comTaskDao.removeRelationTaskList(taskList)).start();
    }

    public List<ComTask> findByComId(String comId) {
        return this.comTaskDao.findByComId(comId);
    }
}

