/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.task.ComTaskSchedulDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.task.BbdTaskSchedul;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.ComTaskSchedul;
import com.bcxin.ars.service.task.ComTaskSchedulService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=ComTaskSchedul.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
public class ComTaskSchedulServiceImpl
implements ComTaskSchedulService {
    Logger logger = LoggerFactory.getLogger(ComTaskSchedulServiceImpl.class);
    @Autowired
    private ComTaskSchedulDao comTaskSchedulDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(ComTaskSchedul comTaskSchedul) {
        User currentUser = this.arsUtil.getCurrentUser();
        comTaskSchedul.setUpdateTime(new Date());
        comTaskSchedul.setUpdateBy(currentUser.getUsername());
        return this.comTaskSchedulDao.delete(comTaskSchedul);
    }

    public int save(ComTaskSchedul comTaskSchedul) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (comTaskSchedul.getId() == null) {
            comTaskSchedul.setCreateTime(new Date());
        } else {
            ComTaskSchedul dbComTaskSchedul = this.comTaskSchedulDao.findById(comTaskSchedul.getId());
            BeanUtils.copyPropertiesIgnore((Object)comTaskSchedul, (Object)dbComTaskSchedul, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbComTaskSchedul, (Object)comTaskSchedul, (Boolean)false);
        }
        comTaskSchedul.setActive(Boolean.valueOf(true));
        comTaskSchedul.setUpdateBy(currentUser.getUsername());
        comTaskSchedul.setUpdateTime(new Date());
        comTaskSchedul.setUpdateflag(Boolean.valueOf(true));
        comTaskSchedul.setAreaCode(currentUser.getPolice().getAreacode());
        return this.comTaskSchedulDao.save(comTaskSchedul);
    }

    public ComTaskSchedul findById(Long id) {
        return this.comTaskSchedulDao.findById(id);
    }

    public void importBatch(List<ComTaskSchedul> list) {
        List dbList = this.comTaskSchedulDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ComTaskSchedul comTaskSchedul : list) {
                comTaskSchedul.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    comTaskSchedul.setUpdateTime(DateUtil.dateAdd((int)6, (Date)comTaskSchedul.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.comTaskSchedulDao.saveBatch(list);
        }
    }

    public List<ComTaskSchedul> findByBatchId(List<ComTaskSchedul> list) {
        return this.comTaskSchedulDao.findByBatchId(list);
    }

    public void saveBatch(List<BbdTaskSchedul> taskScheduls, Long comTaskId, String startDate, String endDate) {
        User currentUser = this.arsUtil.getCurrentUser();
        ArrayList list = new ArrayList();
        ArrayList<String> perIds = new ArrayList<String>();
        for (BbdTaskSchedul bbdTaskSchedul : taskScheduls) {
            perIds.add(bbdTaskSchedul.getPerId());
            list.addAll(bbdTaskSchedul.getTaskSchedulList());
        }
        this.comTaskSchedulDao.deleteByTaskIdPerIdsAndTime(comTaskId, perIds, startDate, endDate);
        if (list.size() > 0) {
            for (ComTaskSchedul schedul : list) {
                schedul.setActive(Boolean.valueOf(true));
                schedul.setUpdateTime(new Date());
                schedul.setUpdateBy(currentUser.getUsername());
            }
            this.comTaskSchedulDao.saveBatch(list);
        }
    }

    public List<ComTaskSchedul> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comTaskSchedulDao.searchForDataSynchronization(dto);
    }

    public List<ComTaskSchedul> findDSOutList(String startDate) {
        return this.comTaskSchedulDao.findDSOutList(startDate);
    }
}

