/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.sys.SysareaDAO;
import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.Tree;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.sys.SysareaSearchDTO;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="areaService")
public class SysareaServiceImpl
implements SysareaService {
    @Autowired
    private SysareaDAO sysareaDAO;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigDao configDao;

    public List<TreeView> searchForTreeView(SysareaSearchDTO sysareaSearchDTO) {
        User user = this.arsUtil.getCurrentUser();
        sysareaSearchDTO.setPath(user.getPolice().getPath());
        sysareaSearchDTO.setUserid(user.getId());
        return this.sysareaDAO.searchForTreeView(sysareaSearchDTO);
    }

    public List<TreeView> searchForCompany(SysareaSearchDTO sysareaSearchDTO) {
        User user = this.arsUtil.getCurrentUser();
        sysareaSearchDTO.setPath(user.getPolice().getPath());
        sysareaSearchDTO.setUserid(user.getId());
        return this.sysareaDAO.searchForCompany(sysareaSearchDTO);
    }

    public SysareaSearchDTO search(SysareaSearchDTO dto) {
        SysareaSearchDTO resultDto = new SysareaSearchDTO();
        List list = this.sysareaDAO.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.sysareaDAO.count(dto)));
        return resultDto;
    }

    public SysareaSearchDTO searchAll(SysareaSearchDTO dto) {
        SysareaSearchDTO resultDto = new SysareaSearchDTO();
        List list = this.sysareaDAO.searchAll(dto);
        resultDto.setData(list);
        return resultDto;
    }

    public List<Sysarea> findByParentId(Long parentid) {
        return this.sysareaDAO.findByParentId(parentid);
    }

    public Sysarea findByCode(String code) {
        return this.sysareaDAO.findByCode(code);
    }

    public List<TreeView> findTreeViewByCode(String areacode) {
        return this.sysareaDAO.findTreeViewByCode(areacode);
    }

    public List<Sysarea> findCurrentAreaList(SysareaSearchDTO sysareaSearchDTO) {
        User user = this.arsUtil.getCurrentUser();
        sysareaSearchDTO.setPath(user.getPolice().getPath());
        sysareaSearchDTO.setUserid(user.getId());
        sysareaSearchDTO.setCode(user.getPolice().getAreacode());
        return this.sysareaDAO.findAreaListByParentCode(sysareaSearchDTO);
    }

    public String findByCodeForFullName(String code) {
        StringBuffer result = new StringBuffer();
        if (StringUtil.isNotEmpty((String)code)) {
            Sysarea province = this.sysareaDAO.findByCode(code.substring(0, 2) + "0000");
            Sysarea city = this.sysareaDAO.findByCode(code.substring(0, 4) + "00");
            Sysarea district = this.sysareaDAO.findByCode(code);
            if (province != null) {
                result.append(province.getName());
            }
            if (city != null) {
                result.append(city.getName());
            }
            if (district != null) {
                result.append(district.getName());
            }
        }
        return result.toString();
    }

    public List<TreeView> searchSimpleTreeView(SysareaSearchDTO sysareaSearchDTO) {
        User user = this.arsUtil.getCurrentUser();
        sysareaSearchDTO.setPath(user.getPolice().getPath());
        sysareaSearchDTO.setUserid(user.getId());
        return this.sysareaDAO.searchSimpleTreeView(sysareaSearchDTO);
    }

    public List<Sysarea> findCurrentSystemAreaList() {
        SysareaSearchDTO sysareaSearchDTO = new SysareaSearchDTO();
        Config provinceConfig = this.configDao.findByKey("current_province");
        sysareaSearchDTO.setCode(provinceConfig.getValue());
        return this.sysareaDAO.findAreaListByParentCode(sysareaSearchDTO);
    }

    public List<Tree> searchForTree(SysareaSearchDTO dto) {
        User currentUser = this.arsUtil.getCurrentUser();
        dto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        List list = this.sysareaDAO.searchForTree(dto);
        ArrayList<Tree> resultList = new ArrayList<Tree>();
        if (list != null && list.size() > 0) {
            Map<String, List<Tree>> treeMap = list.stream().collect(Collectors.groupingBy(Tree::getId));
            Map<String, List<Tree>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(Tree::getParentId));
            for (Tree tree : list) {
                if (groupMap.get(tree.getId()) != null) {
                    tree.setChildren(groupMap.get(tree.getId()));
                } else {
                    tree.setExpanded(true);
                    tree.setState("open");
                }
                if (tree.getParentId() != null && treeMap.get(tree.getParentId()) != null) continue;
                resultList.add(tree);
            }
        }
        return resultList;
    }

    public List<LayTree> searchForLayTree(SysareaSearchDTO searchDto) {
        User currentUser = this.arsUtil.getCurrentUser();
        searchDto.setPoliceBusiness(true);
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        List list = this.sysareaDAO.searchForLayTree(searchDto);
        ArrayList<LayTree> resultList = new ArrayList<LayTree>();
        if (list != null && list.size() > 0) {
            Map<String, List<LayTree>> treeMap = list.stream().collect(Collectors.groupingBy(LayTree::getId));
            Map<String, List<LayTree>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(LayTree::getParentId));
            for (LayTree tree : list) {
                if (groupMap.get(tree.getId()) != null) {
                    tree.setChildren(groupMap.get(tree.getId()));
                } else {
                    tree.setOpen(true);
                }
                if (tree.getParentId() != null && treeMap.get(tree.getParentId()) != null) continue;
                resultList.add(tree);
            }
        }
        return resultList;
    }
}

