/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.ModuleMenuDao;
import com.bcxin.ars.dao.sys.ModulePermissionDao;
import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.MenuTree;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.ModuleMenuPageSearchDto;
import com.bcxin.ars.dto.sys.MenuDto;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.model.sys.ModulePermission;
import com.bcxin.ars.service.sys.ModuleMenuService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ModuleMenuServiceImpl
implements ModuleMenuService {
    Logger logger = LoggerFactory.getLogger(ModuleMenuServiceImpl.class);
    @Autowired
    private ModuleMenuDao moduleMenuDao;
    @Autowired
    private ModulePermissionDao modulePermissionDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;

    public int save(ModuleMenu moduleMenu) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (moduleMenu.getId() == null) {
            moduleMenu.setId(Long.valueOf(this.idWorker.nextId()));
            moduleMenu.setActive(Boolean.valueOf(true));
            moduleMenu.setCreateTime(new Date());
        } else {
            ModuleMenu dbModuleMenu = this.moduleMenuDao.findById(moduleMenu.getId());
            BeanUtils.copyPropertiesIgnore((Object)moduleMenu, (Object)dbModuleMenu, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbModuleMenu, (Object)moduleMenu, (Boolean)false);
        }
        if (moduleMenu.getParentId() != null) {
            ModuleMenu parentMenu = this.moduleMenuDao.findById(moduleMenu.getParentId());
            moduleMenu.setParentIds((StringUtil.isEmpty((String)parentMenu.getParentIds()) ? moduleMenu.getId() + "/" : parentMenu.getParentIds()) + moduleMenu.getId() + "/");
        } else {
            moduleMenu.setParentIds(moduleMenu.getId() + "/");
        }
        moduleMenu.setUpdateBy(currentUser.getUsername());
        moduleMenu.setUpdateTime(new Date());
        return this.moduleMenuDao.save(moduleMenu);
    }

    public ModuleMenu findById(Long id) {
        return this.moduleMenuDao.findById(id);
    }

    public void delete(ModuleMenu moduleMenu) {
        User currentUser = this.arsUtil.getCurrentUser();
        moduleMenu.setActive(Boolean.valueOf(false));
        moduleMenu.setUpdateTime(new Date());
        moduleMenu.setUpdateBy(currentUser.getUsername());
        this.moduleMenuDao.updateSelective(moduleMenu);
    }

    public void updateSeq(ModuleMenu moduleMenu) {
        if (moduleMenu.getParentId() != null) {
            ModuleMenu parentMenu = this.moduleMenuDao.findById(moduleMenu.getParentId());
            moduleMenu.setParentIds((StringUtil.isEmpty((String)parentMenu.getParentIds()) ? "" : parentMenu.getParentIds()) + parentMenu.getId() + "/");
        } else {
            moduleMenu.setParentIds(null);
        }
        if (moduleMenu.getSeq() == null) {
            Integer seq = this.moduleMenuDao.getMaxSeq(moduleMenu.getParentId());
            moduleMenu.setSeq(seq);
        }
        User currentUser = this.arsUtil.getCurrentUser();
        moduleMenu.setUpdateTime(new Date());
        moduleMenu.setUpdateBy(currentUser.getUsername());
        this.moduleMenuDao.save(moduleMenu);
        this.moduleMenuDao.updateSeq(moduleMenu);
    }

    public void enable(ModuleMenu moduleMenu) {
        User currentUser = this.arsUtil.getCurrentUser();
        moduleMenu.setActive(Boolean.valueOf(true));
        moduleMenu.setUpdateTime(new Date());
        moduleMenu.setUpdateBy(currentUser.getUsername());
        this.moduleMenuDao.updateSelective(moduleMenu);
    }

    public List<ModuleMenu> searchForTree(ModuleMenuPageSearchDto dto, AjaxPageResponse page) {
        page.setPagination(false);
        List list = this.moduleMenuDao.searchForPage(dto, page);
        ArrayList<ModuleMenu> treeList = new ArrayList<ModuleMenu>();
        Map<Long, List<ModuleMenu>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(ModuleMenu::getParentId));
        for (ModuleMenu moduleMenu : list) {
            moduleMenu.setChildren(groupMap.get(moduleMenu.getId()));
        }
        for (ModuleMenu moduleMenu : list) {
            if (moduleMenu.getChildren() == null || moduleMenu.getChildren().size() <= 0) {
                moduleMenu.setState("open");
            }
            if (moduleMenu.getParentId() != null) continue;
            treeList.add(moduleMenu);
        }
        return treeList;
    }

    public List<MenuDto> searchForGXTree() {
        List list = this.moduleMenuDao.searchForGX();
        ArrayList<MenuDto> treeList = new ArrayList<MenuDto>();
        Map<Long, List<MenuDto>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(MenuDto::getParentId));
        for (MenuDto moduleMenu : list) {
            moduleMenu.setChildren(groupMap.get(moduleMenu.getId()));
        }
        for (MenuDto moduleMenu : list) {
            moduleMenu.setState("open");
            if (moduleMenu.getParentId() != null) continue;
            treeList.add(moduleMenu);
        }
        return treeList;
    }

    public List<ModuleMenu> findForMenu() {
        User currentUser = this.arsUtil.getCurrentUser();
        List list = this.moduleMenuDao.findByUserAndMenuType(currentUser, Constants.MENUTYPE_MENU);
        ArrayList<ModuleMenu> treeList = new ArrayList<ModuleMenu>();
        Map<Long, List<ModuleMenu>> groupMap = list.stream().filter(menu -> menu.getParentId() != null && menu.getMenuType().equals(Constants.MENUTYPE_MENU)).collect(Collectors.groupingBy(ModuleMenu::getParentId));
        for (ModuleMenu moduleMenu : list) {
            moduleMenu.setChildren(groupMap.get(moduleMenu.getId()));
        }
        for (ModuleMenu moduleMenu : list) {
            if (moduleMenu.getChildren() == null || moduleMenu.getChildren().size() <= 0) {
                moduleMenu.setState("open");
            }
            if (moduleMenu.getParentId() != null) continue;
            treeList.add(moduleMenu);
        }
        return treeList;
    }

    public List<ModuleMenu> setMenuTree(List<ModuleMenu> list) {
        ArrayList<ModuleMenu> treeList = new ArrayList<ModuleMenu>();
        Map<Long, List<ModuleMenu>> groupMap = list.stream().filter(menu -> menu.getParentId() != null && menu.getMenuType().equals(Constants.MENUTYPE_MENU)).collect(Collectors.groupingBy(ModuleMenu::getParentId));
        for (ModuleMenu moduleMenu : list) {
            moduleMenu.setChildren(groupMap.get(moduleMenu.getId()));
        }
        for (ModuleMenu moduleMenu : list) {
            if (moduleMenu.getChildren() == null || moduleMenu.getChildren().size() <= 0) {
                moduleMenu.setState("open");
            }
            if (moduleMenu.getParentId() != null) continue;
            treeList.add(moduleMenu);
        }
        return treeList;
    }

    public List<MenuTree> findMenuTreeForPermission(Long roleId) {
        User currentUser = this.arsUtil.getCurrentUser();
        ArrayList<MenuTree> result = new ArrayList<MenuTree>();
        List list = this.moduleMenuDao.findMenuTreeForPermission(currentUser, roleId);
        List permissionList = this.modulePermissionDao.findByRoleId(roleId);
        Map permissionMap = permissionList.stream().collect(Collectors.toMap(ModulePermission::getModuleMenuId, Function.identity()));
        if (list != null && list.size() > 0) {
            List roleList;
            boolean disabled = false;
            if (roleId != null && (roleList = currentUser.getRoles()) != null && roleList.size() > 0) {
                for (PoliceRole role : roleList) {
                    if (role.getId().longValue() != roleId.longValue()) continue;
                    disabled = true;
                }
            }
            ArrayList<MenuTree> treeList = new ArrayList<MenuTree>();
            String mainId = "1";
            MenuTree mainTree = new MenuTree();
            mainTree.setId(mainId);
            mainTree.setLabel("\u5168\u9009");
            mainTree.setSpread(true);
            mainTree.setDisabled(disabled);
            Map<String, List<MenuTree>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(MenuTree::getParentId));
            for (MenuTree menuTree : list) {
                menuTree.setDisabled(disabled);
                if (permissionMap.get(Long.parseLong(menuTree.getId())) != null) {
                    menuTree.setChecked(true);
                }
                menuTree.setChildren(groupMap.get(menuTree.getId()));
                if (menuTree.getChildren() != null && menuTree.getChildren().size() > 0) {
                    menuTree.setChecked(false);
                }
                if (menuTree.getParentId() != null) continue;
                menuTree.setParentId(mainId);
                treeList.add(menuTree);
            }
            mainTree.setChildren(treeList);
            result.add(mainTree);
        }
        return result;
    }

    public List<LayTree> findForLayTree() {
        User currentUser = this.arsUtil.getCurrentUser();
        List list = this.moduleMenuDao.findForLayTree(currentUser);
        ArrayList<LayTree> resultList = new ArrayList<LayTree>();
        if (list != null && list.size() > 0) {
            Map<String, List<LayTree>> treeMap = list.stream().collect(Collectors.groupingBy(LayTree::getId));
            Map<String, List<LayTree>> groupMap = list.stream().filter(menu -> menu.getParentId() != null).collect(Collectors.groupingBy(LayTree::getParentId));
            for (LayTree tree : list) {
                if (groupMap.get(tree.getId()) != null) {
                    tree.setChildren(groupMap.get(tree.getId()));
                } else {
                    tree.setOpen(true);
                }
                if (tree.getParentId() != null && treeMap.get(tree.getParentId()) != null) continue;
                resultList.add(tree);
            }
        }
        return resultList;
    }

    public List<ModuleMenu> findForPermission(User user) {
        return this.moduleMenuDao.findForPermission(user);
    }

    public void useOld(ModuleMenu moduleMenu) {
        List menus = this.moduleMenuDao.getOldData2(moduleMenu.getPlatform());
        for (ModuleMenu menu : menus) {
            menu.setId(Long.valueOf(this.idWorker.nextId()));
            menu.setActive(Boolean.valueOf(true));
            menu.setCreateTime(new Date());
            menu.setUpdateTime(new Date());
            menu.setParentIds(menu.getParentIds() + menu.getId() + "/");
            menu.setUpdateBy("system");
            this.moduleMenuDao.save(menu);
        }
        menus = this.moduleMenuDao.getOldData3(moduleMenu.getPlatform());
        for (ModuleMenu menu : menus) {
            menu.setId(Long.valueOf(this.idWorker.nextId()));
            menu.setActive(Boolean.valueOf(true));
            menu.setCreateTime(new Date());
            menu.setUpdateTime(new Date());
            menu.setParentIds(menu.getParentIds() + menu.getId() + "/");
            menu.setUpdateBy("system");
            this.moduleMenuDao.save(menu);
        }
    }

    public ModuleMenu findByUniqueId(String uniqueId) {
        return this.moduleMenuDao.findByUniqueId(uniqueId);
    }

    public void searchForPage(ModuleMenuPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.moduleMenuDao.searchForPage(dto, page);
    }
}

