/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sys.impl;

import cn.jiguang.common.utils.StringUtils;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.ImportConfigDaoAop;
import com.bcxin.ars.dao.sys.ImportConfigDao;
import com.bcxin.ars.dao.sys.ImportDao;
import com.bcxin.ars.dao.sys.SubsidyComparisonDao;
import com.bcxin.ars.dto.subsidy.ImportAopDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.sys.ImportConfig;
import com.bcxin.ars.service.bean.factory.ImportBusinessBeanFactory;
import com.bcxin.ars.service.subsidy.GradeSubsidyRosterService;
import com.bcxin.ars.service.subsidy.ImportBusiness;
import com.bcxin.ars.service.sys.ImportService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportServiceImpl
implements ImportService {
    @Autowired
    private ImportConfigDao importConfigDao;
    @Autowired
    private ImportDao importDao;
    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;
    @Autowired
    private SubsidyComparisonDao subsidyComparisonDao;
    @Autowired
    private ImportConfigDaoAop importConfigDaoAop;
    @Autowired
    private GradeSubsidyRosterService gradeSubsidyRosterService;

    public ImportConfig importRoster(String businessType) {
        return this.importConfigDao.selectByBusinessType(businessType);
    }

    public List<Map<String, String>> selectCheckImportList(List<Map<String, String>> list, ImportConfig importConfig) {
        ArrayList<Map<String, String>> failList = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> updateList = new ArrayList<Map<String, String>>();
        ArrayList<String> fileList = new ArrayList<String>();
        fileList.add(importConfig.getFiledName());
        fileList.add(importConfig.getResultFiledName());
        String where = "";
        ImportBusiness importBusiness = ImportBusinessBeanFactory.getImportBusinessBean(importConfig.getBusinessType());
        if (importBusiness == null) {
            throw new ArsException("\u672a\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u7c7b\u578b");
        }
        where = importBusiness.addFileList(fileList);
        List mapList = this.importDao.selectByIdNum(list, fileList, importConfig, where);
        if (mapList == null || mapList.size() == 0) {
            list.forEach(data -> data.put("errorMsg", "\u7cfb\u7edf\u4e2d\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u7684\u8eab\u4efd\u8bc1\u53f7"));
            return list;
        }
        updateList.addAll(list);
        list.forEach(data -> {
            Boolean flag = false;
            String errorMsg = "";
            for (int i = 0; i < mapList.size(); ++i) {
                if (((Map)mapList.get(i)).get(importConfig.getFiledName()).equals(data.get("keyValue"))) {
                    String subsidyStatus = (String)((Map)mapList.get(i)).get(importConfig.getResultFiledName());
                    if (StringUtils.isNotEmpty((String)subsidyStatus) && !"01".equals(subsidyStatus)) {
                        errorMsg = "\u8be5\u4eba\u5458\u5df2\u6bd4\u5bf9";
                        flag = true;
                        break;
                    }
                    String errorMsgBusiness = "";
                    errorMsgBusiness = importBusiness.addErrorMsg((Map)mapList.get(i));
                    if (StringUtils.isNotEmpty((String)errorMsgBusiness)) {
                        flag = true;
                        errorMsg = errorMsgBusiness;
                        break;
                    }
                    flag = false;
                    break;
                }
                flag = true;
                errorMsg = "\u7cfb\u7edf\u4e2d\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u7684\u8eab\u4efd\u8bc1\u53f7";
            }
            if (flag.booleanValue()) {
                updateList.remove(data);
                data.put("errorMsg", errorMsg);
                failList.add((Map<String, String>)data);
            }
        });
        if (updateList == null || updateList.size() == 0) {
            return failList;
        }
        List<Map<String, String>> updateStatusList = this.getSubsidyStatus(updateList, importConfig.getBusinessType(), importConfig, failList);
        if (updateStatusList != null && updateStatusList.size() > 0) {
            List rosterList;
            Date inTime = null;
            if (importConfig.getBusinessType().equals("01")) {
                inTime = new Date();
            }
            ImportAopDto importAopDto = new ImportAopDto();
            importAopDto.setUpdateStatusList(updateStatusList);
            importAopDto.setImportConfig(importConfig);
            importAopDto.setInTime(inTime);
            importAopDto.setWhere(where);
            importAopDto.setTableName(importConfig.getTableName());
            this.importConfigDaoAop.updateListV1(importAopDto);
            if ("02".equals(importConfig.getBusinessType()) && (rosterList = this.gradeSubsidyRosterDao.findByImportConfig(importAopDto)).size() > 0) {
                this.gradeSubsidyRosterService.compareStatusToBKT(rosterList);
            }
        }
        return failList;
    }

    public List<Map<String, String>> getSubsidyStatus(List<Map<String, String>> list, String businessType, ImportConfig importConfig, List<Map<String, String>> failList) {
        List subsidyComparisons = this.subsidyComparisonDao.selectAllByBusinessType(businessType);
        ArrayList<Map<String, String>> updateList1 = new ArrayList<Map<String, String>>();
        updateList1.addAll(list);
        list.forEach(map -> {
            String code = (String)map.get("resultValue");
            map.put("resultValue", "");
            subsidyComparisons.forEach(subsidyComparison -> {
                if (subsidyComparison.getCode().equals(code)) {
                    map.put("resultValue", subsidyComparison.getFlowTo());
                }
            });
            if (StringUtils.isEmpty((String)((String)map.get("resultValue")))) {
                map.put("resultValue", code);
                map.put("errorMsg", "\u672a\u67e5\u8be2\u5230\u8be5\u6bd4\u5bf9\u7ed3\u679c\u7684\u6d41\u5411");
                failList.add((Map<String, String>)map);
                updateList1.remove(map);
            }
        });
        return updateList1;
    }
}

