/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.PersonComplaintDao;
import com.bcxin.ars.dao.supervision.PersonComplaintDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.PersonComplaintPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.PersonComplaint;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.supervision.PersonComplaintService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=PersonComplaint.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=PersonComplaint.class, getImportType=ImportType.BATCH)
public class PersonComplaintServiceImpl
extends BaseService
implements PersonComplaintService {
    @Autowired
    private PersonComplaintDao personComplaintDao;
    @Autowired
    private PersonComplaintDaoAop personComplaintDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;

    public int delete(PersonComplaint record) {
        User currentUser = this.arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return this.personComplaintDaoAop.delete(record);
    }

    public void save(PersonComplaint record) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (record.getId() == null) {
            record.setId(Long.valueOf(this.idWorker.nextId()));
            record.setCreateTime(new Date());
            if (StringUtil.isNotEmpty((String)record.getSignImgPath())) {
                record.setSignImgPath(this.saveBase64Img(record.getSignImgPath()));
            }
        } else {
            PersonComplaint dbRecord = this.personComplaintDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore((Object)record, (Object)dbRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbRecord, (Object)record, (Boolean)false);
        }
        record.setActive(Boolean.valueOf(true));
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(Boolean.valueOf(true));
        record.setAreaCode(currentUser.getPolice().getAreacode());
        this.personComplaintDaoAop.save(record);
    }

    public PersonComplaint findById(Long id) {
        return this.personComplaintDao.findById(id);
    }

    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        this.arsUtil.setPoliceSearch(dto);
        PersonComplaintPageSearchDto searchDto = (PersonComplaintPageSearchDto)dto;
        if (StringUtil.isNotEmpty((String)searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        this.personComplaintDao.searchForPage(searchDto, page);
    }

    public List<PersonComplaint> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.personComplaintDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(List<PersonComplaint> list) {
        ArrayList<PersonComplaint> dbList = new ArrayList<PersonComplaint>();
        for (PersonComplaint personComplaint : list) {
            PersonComplaint personComplaintIn = this.personComplaintDao.findById(personComplaint.getId());
            if (personComplaintIn == null) {
                personComplaint.setUpdateflag(Boolean.valueOf(false));
                continue;
            }
            if (personComplaint.getUpdateTime().getTime() < personComplaintIn.getUpdateTime().getTime()) {
                dbList.add(personComplaint);
            }
            personComplaint.setUpdateflag(Boolean.valueOf(true));
        }
        list.removeAll(dbList);
        this.personComplaintDaoAop.saveBatch(list);
    }

    public List<PersonComplaint> findDSOutList(String startDate) {
        return this.personComplaintDao.findDSOutList(startDate);
    }

    public void importBatch(List<PersonComplaint> list) {
        List dbList = this.personComplaintDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PersonComplaint personComplaint : list) {
                personComplaint.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    personComplaint.setUpdateTime(DateUtil.dateAdd((int)6, (Date)personComplaint.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.personComplaintDaoAop.saveBatch(list);
        }
    }
}

